/*------------------------------------------------------------------------------*
 * File Name: ImpWizHeadLines.c													*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 10-15-2004 v8.0149 QA70-5658 IMPROVE_HDRVAR_EXTRACTION					*
 * EJP 11-18-2004 v8.0164 QA70-6554 EXTRACT_VARS_FROM_FILENAME					*
 * EJP 2005-01-28 v8.0187 IMPROVE_NUMBER_OF_PREVIEW_HEADLINES					*
 * EJP 2005-02-01 v8.0187 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL				*
 * EJP 2005-02-16 v8.0193 QA70-7038 IMPROVE_HEADER_LINE_COLORING				*
 * EJP 2005-08-26 v8.0196 QA70-7894 USER_SPECIFY_NUM_PREVIEW_LINES				*
 * EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA								*
 * Sim 08-20-2007 ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW							*
 * Hong 09/19/07 QA80-9206 FIX_ZERO_COL_NUM_FAIL_CORRECT_IMPORT_MULTI_FILES		*
 *	Hong 09/21/07 QA80-9206 FIX_AUTO_HEADERLINE_NOT_UPDATE_REALTIME				*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "IWfirst.h"

/// EJP 2005-02-01 v8.0187 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
// Line format is: 3 digits for line number, space, 5 line type chars, space, line text
// See ImpWizHeadLinesPage::UpdatePreviewLines method where prefix is generated
///---Sim 08-20-2007 ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
/*
#define LINE_NUM_AND_TYPE_PREFIX			"%03d        " ///---Sim 01-26-2007 SUPPORT_USER_PARAMETER extend prefix string
#define LINE_NUM_AND_TYPE_PREFIX_LEN		11 ///---Sim 01-26-2007 SUPPORT_USER_PARAMETER extend prefix string
#define NUM_LINE_TYPES						(LINE_TYPE_LAST - LINE_TYPE_FIRST + 1)
enum {
	LINE_TYPE_CHAR_OFFSET = 3, // 3 digit line number and 1 space
	LINE_TYPE_FIRST,
	LINE_TYPE_CHAR_OFFSET_SHORT_NAME = LINE_TYPE_FIRST,
	LINE_TYPE_CHAR_OFFSET_LONG_NAME,
	LINE_TYPE_CHAR_OFFSET_UNIT,
	LINE_TYPE_CHAR_OFFSET_COMMENT,
	LINE_TYPE_CHAR_OFFSET_PARAMETER,
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	//LINE_TYPE_LAST = LINE_TYPE_CHAR_OFFSET_PARAMETER
	LINE_TYPE_CHAR_OFFSET_USER_PARAMETER,
	LINE_TYPE_LAST = LINE_TYPE_CHAR_OFFSET_USER_PARAMETER
	///---END SUPPORT_USER_PARAMETER
};
*/
#define LINE_NUM_LEN 4 // 3 digit line number and 1 space
#define LINE_NUM_PREFIX			"%03d "

#define HEADER_LINE_NUM_LEN 6 // 2 char header mark and 3 digit line number and 1 space
#define HEADER_LINE_NUM_PREFIX	"%03d%cH "

enum {
	LINE_TYPE_LINE_NUM = LINE_NUM_LEN - 1,
	LINE_TYPE_FIRST,
	LINE_TYPE_HEADER_FIRST = LINE_TYPE_FIRST,
	LINE_TYPE_HEADER_LINE_NUM = LINE_TYPE_HEADER_FIRST + HEADER_LINE_NUM_LEN - 1, 
	LINE_TYPE_CHAR_FIRST,
	LINE_TYPE_CHAR_OFFSET_SHORT_NAME = LINE_TYPE_CHAR_FIRST,
	LINE_TYPE_CHAR_OFFSET_LONG_NAME,
	LINE_TYPE_CHAR_OFFSET_UNIT,
	LINE_TYPE_CHAR_OFFSET_COMMENT,
	LINE_TYPE_CHAR_OFFSET_PARAMETER,
	LINE_TYPE_CHAR_OFFSET_USER_PARAMETER,
	LINE_TYPE_CHAR_LAST = LINE_TYPE_CHAR_OFFSET_USER_PARAMETER,
	LINE_TYPE_LAST = LINE_TYPE_CHAR_LAST,
};

#define LINE_NUM_AND_TYPE_PREFIX_LEN		(LINE_TYPE_LAST + 1) + 1 // all line type char and 1 space

#define NUM_LINE_TYPES						(LINE_TYPE_LAST - LINE_TYPE_FIRST + 1)

enum{
	MAIN_HEADER_LINE,
	SUB_HEADER_LINE,
};
///---END ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
/// end SKIP_CHARS_FOR_COL_NAME_LABEL

///Danice 12/25/03 v7.5788 NOTUSE_SHOW
DWORD ImpWizHeadLinesPage::OnShowStatus(DWORD InternalStatus)
{
	return (IS_FILTER_TYPE_ASCII ? PSS_Show : PSS_Ignore);
}
///END NOTUSE_SHOW

void ImpWizHeadLinesPage::InitializeBitmapButtons()
{
	BitmapRadioButton radioButton;
	
	radioButton = GetItem(IDC_IW_HEADER_LINES_TBHLDR);
	vector<string>  vstrTips;
	vstrTips.SetSize(1);
	vstrTips[0] = _L("Position cursor on last line of header and click refresh button");
	radioButton.Init(1, IDB_REFRESH_BLACK, 16, vstrTips);
	
	radioButton = GetItem(IDC_IW_COL_NAME_TBHLDR);
	vstrTips[0] = _L("Position cursor on line containing column names and click refresh button");
	radioButton.Init(1, IDB_REFRESH_RED, 16, vstrTips);
	
	radioButton = GetItem(IDC_IW_COL_LABEL_TBHLDR);
	vstrTips[0] = _L("Position cursor on first line of column labels and click refresh button");
	radioButton.Init(1, IDB_REFRESH_MAGENTA, 16, vstrTips);
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	vstrTips[0] = _L("Position cursor on last line of sub header and click refresh button");
	m_btnSubHeaderLinesUpdate.Init(1, IDB_REFRESH_BROWN, 16, vstrTips);
	///---END SUPPORT_AUTO_HEADER_LINES
	
	/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
	vstrTips[0] = _L("Select line containing long column names and click");
	m_btnColLongNameUpdate.Init(1, IDB_REFRESH_BLUE, 16, vstrTips);
	vstrTips[0] = _L("Select line containing column units and click");
	m_btnColUnitUpdate.Init(1, IDB_REFRESH_GREEN, 16, vstrTips);
	vstrTips[0] = _L("Select lines containing column parameters and click");
	m_btnColParamUpdate.Init(1, IDB_REFRESH_CYAN_DARK, 16, vstrTips);
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	vstrTips[0] = _L("Select lines containing column user parameters and click");
	/// Hong 05/23/07 BETTER_COLOR
	//m_btnColUserParamUpdate.Init(1, IDB_REFRESH_YELLOW, 16, vstrTips);
	m_btnColUserParamUpdate.Init(1, IDB_REFRESH_PURPLE, 16, vstrTips);
	/// end BETTER_COLOR
	///---END SUPPORT_USER_PARAMETER
	vstrTips[0] = _L("Select lines to save and click");
	m_btnSaveUpdate.Init(1, IDB_REFRESH_BLACK, 16, vstrTips);
	/// end MORE_HEADER_LINE_TYPES
}

bool ImpWizHeadLinesPage::OnInit_AscHeader()		///Danice 12/14/03 V 7.5781 CHANGE_FUNCTION_NAME
{
	ON_PAGE_CHECK_ASC_HEADER
	
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE

	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	m_btnHeaderLinesUpdate		= GetItem(IDC_IW_HEADER_LINES_TBHLDR);
	m_btnSubHeaderLinesUpdate	= GetItem(IDC_IW_SUB_HEADER_LINES_TBHLDR);
	///---END SUPPORT_AUTO_HEADER_LINES
	
	/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
	m_cbColLongNameFrom = GetItem(IDC_COL_LONGNAME_FROM);
	m_cbColUnitFrom = GetItem(IDC_COL_UNIT_FROM);
	m_cbColParamFrom = GetItem(IDC_COL_PARAM_FROM);
	m_cbColParamTo = GetItem(IDC_COL_PARAM_TO);
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	m_cbColUserParamFrom = GetItem(IDC_COL_USER_PARAM_FROM);
	m_cbColUserParamTo = GetItem(IDC_COL_USER_PARAM_TO);
	///---END SUPPORT_USER_PARAMETER
	m_cbSaveLineFrom = GetItem(IDC_HDR_SAVE_FROM);
	m_cbSaveLineTo = GetItem(IDC_HDR_SAVE_TO);
	m_btnColLongNameUpdate = GetItem(IDC_COL_LONGNAME_UPDATE);
	m_btnColUnitUpdate = GetItem(IDC_COL_UNIT_UPDATE);
	m_btnColParamUpdate = GetItem(IDC_COL_PARAM_UPDATE);
	m_btnColUserParamUpdate = GetItem(IDC_COL_USER_PARAM_UPDATE); ///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	m_btnSaveUpdate = GetItem(IDC_SAVE_HDR_UPDATE);
	/// end MORE_HEADER_LINE_TYPES

	InitializeBitmapButtons();
	
	/// Hong 04/28/07 QA80-8584-S12 ALLOW_SEPCIAL_USER_PARAMETER_NAME
	m_btnUDLNames =	GetItem(IDC_COL_USER_PARAM_SET_NAME);
	m_btnUDLNames.Visible = 0; // hidden this for 8.0 release, will add it in SR1
	/// end ALLOW_SEPCIAL_USER_PARAMETER_NAME
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	m_cbSubHeaderLines 	= 		GetItem(IDC_IW_SUB_HEADER_LINES);
	m_chkAutoSubHeaderLines	=		GetItem(IDC_IW_AUTO_HEADER_LINES);
	m_chkLineNumberFromBottom	=	GetItem(IDC_IW_LINE_NUMBER_FROM_BOTTOM);
	///---END SUPPORT_AUTO_HEADER_LINES

	///Danice 12/14/03 v7.5781 GET_CONTROL_IN_START : initialization control
	m_btnColLabelRefresh = 	GetItem(IDC_IW_COL_LABEL_TBHLDR);
	m_btnColNameRefresh = 	GetItem(IDC_IW_COL_NAME_TBHLDR);
	m_cbFirstLine = 		GetItem(IDC_HDR_SAVE_FROM);
	m_cbLastLine = 			GetItem(IDC_HDR_SAVE_TO);
	/// EJP 11-18-2004 v8.0164 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	///m_chkDefineVar = 		GetItem(IDC_HDRPARAM_DEFINEVAR);
	/// end EXTRACT_VARS_FROM_FILENAME
	m_cbColNameLabelOffset = GetItem(IDC_NAME_LABEL_CHAR_OFFSET);
	m_cbHeaderLines = 		GetItem(IDC_IW_HEADER_LINES);
	//m_cmbxHeaderLines = 	GetItem(IDC_IW_HEADER_LINES);
	m_cbColNameFrom = 		GetItem(IDC_IW_COL_NAME_FROM);
	//m_cmbxColNameFrom = 	GetItem(IDC_IW_COL_NAME_FROM);
	m_cbColLabelFrom = 		GetItem(IDC_IW_COL_LABEL_FROM);
	//m_cmbxColLabelFrom = 	GetItem(IDC_IW_COL_LABEL_FROM);
	m_cbColLabelTo = 		GetItem(IDC_HDR_LABEL_TO);
	//m_cmbxColLabelTo = 		GetItem(IDC_HDR_LABEL_TO);
	//m_mbxColLabelTo = 		GetItem(IDC_HDR_LABEL_TO);
	//m_reAscPreview = 		GetItem(IDC_HEADER_PREVIEW);
	//m_reHdr = 				GetItem(IDC_HEADER_PREVIEW);
	m_reHdrPreview = 		GetItem(IDC_HEADER_PREVIEW);
	//m_rePreview = 			GetItem(IDC_HEADER_PREVIEW);
	///END GET_CONTROL_IN_START
	
	/// EJP 2005-08-26 v8.0196 QA70-7894 USER_SPECIFY_NUM_PREVIEW_LINES
	m_cbPreviewLines = GetItem(IDC_PREVIEW_LINES);
	/// end USER_SPECIFY_NUM_PREVIEW_LINES
	
	//m_pSheet->GetASCIMP(m_pAscimp);		///Danice CALL_SHEET_FUNCTION : INIT	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	m_pAscimp = m_pSheet->GetASCIMP_Pointer();
	
	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	///RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_HEADER_PREVIEW, IDD_AIW_HEADER);
	///reAscPreview.SetFont(SYSTEM_FIXED_FONT);
	///AscHdr_UpdatePreviewText();
	///reAscPreview.SetSel(0, 0); // Position cursor at top left of preview window
	
	//iw_InitFontComboBox(IDC_ASC_PREVIEW_FONT, IDD_AIW_HEADER);	///Danice 12/14/03 v7.5781 REWRITE_FUNCTION
	iw_InitFontComboBox(IDC_ASC_PREVIEW_FONT);
	//AscHdr_UpdatePreviewText();		///Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA
	/// end ALLOW_CHANGING_PREVIEW_FONT

	/// EJP 2005-02-03 v8.0187 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
	/*
	int nCheck;
	// If filter has Defined attribute (indicating it has been here before)
	if( fuGetHeaderParamDefined(s_trFilter, nCheck) )
		/// EJP 10-15-2004 v8.0149 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
		///// Use parameter count to determine default check box state
		///nCheck = (fuGetHeaderParamCount(s_trFilter) ? 1 : 0);
		nCheck = (FLT_HDRVAR_NONE == fuGetVarMethod(IW_FILTER) ? 0 : 1);
		/// end IMPROVE_HDRVAR_EXTRACTION
	else // no Defined attribute
		// Use header line count to determine default check box state
		nCheck = (ASCIMP_TOTAL_HEADER_LINES(m_pAscimp) ? 1 : 0);
	if( nCheck )
		ENABLE_DEFINE_HDR_VAR;
	else
		DISABLE_DEFINE_HDR_VAR;
	*/
	/// end IMPROVE_HDRVAR_EXTRACTION
		
	//m_pSheet->SetASCIMP(m_pAscimp);	///Danice 12/23/03 v7.5786 SAVE_CHANGE	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER

	return TRUE;
}

void ImpWizHeadLinesPage::iw_InitFontComboBox(int iCtrl)
{
	ComboBox cbFonts = GetItem(iCtrl);
	if( cbFonts )
	{
		int iFontIDs[] = {OEM_FIXED_FONT, ANSI_FIXED_FONT, SYSTEM_FIXED_FONT};
		m_pSheet->iw_InitComboBox(cbFonts, _L("OEM|ANSI|System"), iFontIDs);
		m_pSheet->SetComboBoxCurSelByData(cbFonts, IW_PREVIEW_FONT);
	}
}

bool ImpWizHeadLinesPage::OnActive_AscHeader()		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ON_PAGE_CHECK_ASC_HEADER
	
	///Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA
	/// EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA
	///if(m_pSheet->IsUpgradeData())
	if( m_pSheet->IsUpgradeData(IW_UPGRADE_ASCII_DATA) )
	/// end FOR_CONTROL_UPGRADE_DATA
		AscHdr_UpdatePreviewText();
	///END FOR_CONTROL_UPGRADE_DATA

	//m_pSheet->GetASCIMP(m_pAscimp);		///Danice CALL_SHEET_FUNCTION : INIT		///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	
	/// EJP 10-20-2003 v7.5726 QA70-5374 ALLOW_CHANGING_PREVIEW_FONT
	//RichEdit reHdr = ImportWizDlg.GetItem(IDC_HEADER_PREVIEW, IDD_AIW_HEADER);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	
	if( m_reHdrPreview )
		m_reHdrPreview.SetFont(IW_PREVIEW_FONT);
	/// end ALLOW_CHANGING_PREVIEW_FONT

	/// EJP 07-14-2003 v7.0624 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
	m_iStartingNumHdrLines = ASCIMP_TOTAL_HEADER_LINES(m_pAscimp);
	/// end SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
	
	AscHeader_Update();
	return TRUE;
}

bool ImpWizHeadLinesPage::OnKillActive_AscHeader()		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ON_PAGE_CHECK_ASC_HEADER
	AscHeader_Update(FALSE); // FALSE = dlg to data

	/// Hong 9/18/06 UPDATE_FILTER_WITH_STRUCTURE
	fuSetASCIMP(s_trFilter, *m_pAscimp);
	/// end UPDATE_FILTER_WITH_STRUCTURE
	/// EJP 07-14-2003 v7.0624 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
	/// Hong 09/19/07 QA80-9206 FIX_ZERO_COL_NUM_FAIL_CORRECT_IMPORT_MULTI_FILES
	/* this code is not reasonable as user may have specify column number or keep default to 0 meaning auto detect by file
	if( m_iStartingNumHdrLines != ASCIMP_TOTAL_HEADER_LINES(m_pAscimp) )
		ENABLE_RESCAN_FOR_NUM_COLS;
	*/
	/// end FIX_ZERO_COL_NUM_FAIL_CORRECT_IMPORT_MULTI_FILES
	/// end SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
	
	//m_pSheet->SetASCIMP(m_pAscimp);	///Danice 12/22/03 v7.5784 SAVE_CHANGE	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	return TRUE;
}

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
BOOL ImpWizHeadLinesPage::OnChangeSubHeaderLines_AscHeader(Control ctrl)
{
	///---Sim 01-24-2007 MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
	//int nMainHeaderLines, nSubHeaderLines;
	//nMainHeaderLines = atoi(m_cbHeaderLines.Text);
	//nSubHeaderLines = atoi(m_cbSubHeaderLines.Text);
	//AscHdr_SetActualHeaderLinesByAuto(nMainHeaderLines, nSubHeaderLines, m_chkAutoSubHeaderLines.Check);
	///---END MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
	
	return OnChangeHeaderLines_AscHeader(ctrl);
}

BOOL ImpWizHeadLinesPage::OnSelChangeSubHeaderLines_AscHeader(Control ctrl)
{
	ComboBox cmbSubHeaderLines(ctrl);
	int nCurSel = cmbSubHeaderLines.GetCurSel();
	string str;
	cmbSubHeaderLines.GetLBText(nCurSel, str);
	cmbSubHeaderLines.Text = str;
	return OnChangeSubHeaderLines_AscHeader(ctrl);
}

BOOL ImpWizHeadLinesPage::OnRefreshSubHeaderLines_AscHeader(Control cntrl)
{
	long nStartChar, nEndChar;
	m_reHdrPreview.GetSel(nStartChar, nEndChar);
	int nLineNumber = m_reHdrPreview.LineFromChar(nEndChar) + 1;
	
	int nMainLines = atoi(m_cbHeaderLines.Text);
	int nSubLines = nLineNumber - nMainLines;
	if ( nSubLines < 0 )
		nSubLines = 0;
	
	m_cbSubHeaderLines.Text.Format("%d", nSubLines);

	Control ctrl = m_cbSubHeaderLines;
	OnChangeSubHeaderLines_AscHeader(ctrl);
	
	m_reHdrPreview.SetSel(nEndChar, nEndChar);

	return TRUE;
}

BOOL ImpWizHeadLinesPage::OnClickAutoSubHeaderLines_AscHeader(Control ctrl)
{
	int nAutoHeaderLines = m_chkAutoSubHeaderLines.Check;

	if ( !nAutoHeaderLines )
	{
		m_chkLineNumberFromBottom.Check = 0;
	}
	else
	{
		///---Sim 01-24-2007 MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
		int nMainHeaderLines, nSubHeaderLines;
		AscHdr_SetActualHeaderLinesByAuto(0, 0, nAutoHeaderLines);
		AscHdr_GetActualHeaderLines(&nMainHeaderLines, &nSubHeaderLines);
		SetHeaderLines(nMainHeaderLines, nSubHeaderLines, nAutoHeaderLines, true); // update to dialog
		///---END MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
	}
	
	///---Sim 01-24-2007 MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
	//int nMainHeaderLines, nSubHeaderLines;
	//nMainHeaderLines = atoi(m_cbHeaderLines.Text);
	//nSubHeaderLines = atoi(m_cbSubHeaderLines.Text);
	//AscHdr_SetActualHeaderLinesByAuto(nMainHeaderLines, nSubHeaderLines, m_chkAutoSubHeaderLines.Check);
	///---END MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
	
	return OnChangeHeaderLines_AscHeader(ctrl);
}

BOOL ImpWizHeadLinesPage::OnClickLineNumberFromBottom_AscHeader(Control ctrl)
{
	AscHdr_EnableCtrls();
	AscHdr_UpdatePreviewColor();
	return TRUE;
}
///---END SUPPORT_AUTO_HEADER_LINES

BOOL ImpWizHeadLinesPage::OnChangeHeaderLines_AscHeader(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int nMainHeaderLines, nSubHeaderLines;
	nMainHeaderLines = atoi(m_cbHeaderLines.Text);
	nSubHeaderLines = atoi(m_cbSubHeaderLines.Text);
	AscHdr_SetActualHeaderLinesByAuto(nMainHeaderLines, nSubHeaderLines, m_chkAutoSubHeaderLines.Check);
	///---END SUPPORT_AUTO_HEADER_LINES
	
	/// EJP 08-15-2003 v7.5662 CLEAN_HEADER_LINES_INPUT
	/*
	int iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo, iSkipRows;
	AscHeader_GetDialogSettings(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo, iSkipRows);
	if( iHeaderLines < iColNameFrom )
		iColNameFrom = 0;
	if( iHeaderLines < iColLabelFrom )
		iColNameFrom = 0;

	/// EJP 06-11-2003 v7.0600 QA70-4520 SUPPORT_HUGE_HEADER_SIZES
	if( iHeaderLines >= IW_NUM_HEADER_PREVIEW_LINES )
	{
		IW_NUM_HEADER_PREVIEW_LINES = iHeaderLines + 5; // 5=to show some data lines
		AscHdr_UpdatePreviewText();
	}
	/// end SUPPORT_HUGE_HEADER_SIZES
		
	AscHeader_SetDialogSettings(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo, iSkipRows);
	AscHeader_UpdatePreview(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo, iSkipRows);
	AscHeader_SetAscImpStruct(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
	*/
	int iHeaderLines = AscHdr_GetActualHeaderLines(); ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	if( iHeaderLines >= IW_NUM_HEADER_PREVIEW_LINES )
	{
		/// EJP 2005-01-28 v8.0187 IMPROVE_NUMBER_OF_PREVIEW_HEADLINES
		///	//IW_NUM_HEADER_PREVIEW_LINES = iHeaderLines + 5; // 5=to show some data lines	///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
		///	m_pSheet->SetPreviewFont(iHeaderLines + 5);
		m_pSheet->SetASCPreviewLines(iHeaderLines + 5);
		/// end IMPROVE_NUMBER_OF_PREVIEW_HEADLINES
		AscHdr_UpdatePreviewText();
	}
	AscHdr_DialogToASCIMP();
	AscHdr_EnableCtrls();
	AscHdr_UpdatePreviewColor();
	/// end CLEAN_HEADER_LINES_INPUT
	return TRUE;
}

BOOL ImpWizHeadLinesPage::OnSelChangeHeaderLines_AscHeader(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ComboBox cmbHeaderLines(ctrl);
	int nCurSel = cmbHeaderLines.GetCurSel();
	string str;
	cmbHeaderLines.GetLBText(nCurSel, str);
	cmbHeaderLines.Text = str;
	return OnChangeHeaderLines_AscHeader(ctrl);
}

//BOOL OnRefreshHeaderLines_AscHeader()		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
BOOL ImpWizHeadLinesPage::OnRefreshHeaderLines_AscHeader(Control cntrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	//RichEdit reAscPreview = ImportWizDlg.GetItem(IDC_HEADER_PREVIEW, IDD_AIW_HEADER);	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
	
	long nStartChar, nEndChar;
	m_reHdrPreview.GetSel(nStartChar, nEndChar);
	int nLineNumber = m_reHdrPreview.LineFromChar(nEndChar) + 1;

	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int nMainLines = atoi(m_cbHeaderLines.Text);
	int nSubLines = atoi(m_cbSubHeaderLines.Text);
	int nHeaderLines = nMainLines + nSubLines;
	
	nMainLines = nLineNumber;
	nSubLines = nHeaderLines - nMainLines;
	if ( nSubLines < 0 )
		nSubLines = 0;
	
	//string str;
	//str.Format("%d", nLineNumber);
	////ComboBox cmbxHeaderLines = ImportWizDlg.GetItem(IDC_IW_HEADER_LINES, IDD_AIW_HEADER);	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
	//
	//m_cbHeaderLines.Text = str;
	m_cbHeaderLines.Text.Format("%d", nMainLines);
	m_cbSubHeaderLines.Text.Format("%d", nSubLines);
	///---END SUPPORT_AUTO_HEADER_LINES

	Control ctrl = m_cbHeaderLines;
	OnChangeHeaderLines_AscHeader(ctrl);
	m_reHdrPreview.SetSel(nEndChar, nEndChar);

	return TRUE;
}

BOOL ImpWizHeadLinesPage::OnEditChangeColNameFrom_AscHdr(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	AscHdr_UpdatePreviewColor();
	AscHdr_EnableCtrls(); /// EJP 11-06-03 v7.5745 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
	return TRUE;
}

bool ImpWizHeadLinesPage::OnSelChangeColNameFrom_AscHdr(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ComboBox cb(ctrl);
	int nCurSel = cb.GetCurSel();
	string str;
	cb.GetLBText(nCurSel, str);
	cb.Text = str;
	AscHdr_UpdatePreviewColor();
	AscHdr_EnableCtrls(); /// EJP 11-06-03 v7.5745 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
	return TRUE;
}

bool ImpWizHeadLinesPage::OnEditChangeColLabelFrom_AscHdr(Control ctrl)		//Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	AscHdr_EnableCtrls();
	AscHdr_UpdatePreviewColor();
	return TRUE;
}

bool ImpWizHeadLinesPage::OnSelChangeColLabelFrom_AscHdr(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ComboBox cb(ctrl);
	int nCurSel = cb.GetCurSel();
	string str;
	cb.GetLBText(nCurSel, str);
	cb.Text = str;
	AscHdr_EnableCtrls();
	AscHdr_UpdatePreviewColor();
	return TRUE;
}

void ImpWizHeadLinesPage::AscHdr_EnableCtrls()
{
	/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
	/*
	int iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo;
	AscHdr_GetFromDialog(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
	bool bHeaderLines = (iHeaderLines > 0);

	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION		
	//ComboBox cbColNameFrom = ImportWizDlg.GetItem(IDC_IW_COL_NAME_FROM, IDD_AIW_HEADER);
	//Control btnColNameRefresh = ImportWizDlg.GetItem(IDC_IW_COL_NAME_TB, IDD_AIW_HEADER);
	//ComboBox cbColLabelFrom = ImportWizDlg.GetItem(IDC_IW_COL_LABEL_FROM, IDD_AIW_HEADER);
	//ComboBox cbColLabelTo = ImportWizDlg.GetItem(IDC_HDR_LABEL_TO, IDD_AIW_HEADER);
	//Control btnColLabelRefresh = ImportWizDlg.GetItem(IDC_IW_COL_LABEL_TB, IDD_AIW_HEADER);
	
	m_cbColNameFrom.Enable = bHeaderLines;
	m_btnColNameRefresh.Enable = m_cbColNameFrom.Enable;
	m_cbColLabelFrom.Enable = bHeaderLines;
	m_cbColLabelTo.Enable = (m_cbColLabelFrom.Enable && iColLabelFrom >= 0);
	m_btnColLabelRefresh.Enable = m_cbColLabelFrom.Enable;

	int iFirstSaveLine, iNumSaveLines;
	AscHdr_GetSaveLines(iFirstSaveLine, iNumSaveLines);
	
	//ComboBox cbFirstLine = ImportWizDlg.GetItem(IDC_HDR_SAVE_FROM, IDD_AIW_HEADER);
	//ComboBox cbLastLine = ImportWizDlg.GetItem(IDC_HDR_SAVE_TO, IDD_AIW_HEADER);
	
	m_cbFirstLine.Enable = bHeaderLines;
	m_cbLastLine.Enable = (m_cbFirstLine.Enable && iNumSaveLines);
	
	/// EJP 11-06-03 v7.5745 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
	//ComboBox cbColNameLabelOffset = ImportWizDlg.GetItem(IDC_NAME_LABEL_CHAR_OFFSET, IDD_AIW_HEADER);
	///END GET_IN_INITIALIZATION

	if( m_cbColNameLabelOffset )
		m_cbColNameLabelOffset.Enable = (bHeaderLines && (iColNameFrom >= 0 || iColLabelFrom >= 0));
	/// end SKIP_CHARS_FOR_COL_NAME_LABEL
	*/
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	m_cbSubHeaderLines.Enable = ( 0 == m_chkAutoSubHeaderLines.Check );
	m_btnSubHeaderLinesUpdate.Enable = m_cbSubHeaderLines.Enable;
	m_cbHeaderLines.Enable = ( 0 == m_chkAutoSubHeaderLines.Check );
	m_btnHeaderLinesUpdate.Enable = m_cbHeaderLines.Enable;
	m_chkLineNumberFromBottom.Enable = ( 1 == m_chkAutoSubHeaderLines.Check );
	///---END SUPPORT_AUTO_HEADER_LINES
	
	HEADERLINEINFO hli;
	GetHeaderLineInfo(hli);
	
	bool bHeaderLines = (hli.HeaderLines > 0);
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	bool bSubHeaderLines = (hli.SubHeaderLines > 0);
	///---END SUPPORT_AUTO_HEADER_LINES

	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//m_cbColNameFrom.Enable = bHeaderLines;
	m_cbColNameFrom.Enable = bSubHeaderLines;
	///---END SUPPORT_AUTO_HEADER_LINES
	m_btnColNameRefresh.Enable = m_cbColNameFrom.Enable;
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//m_cbColLongNameFrom.Enable = bHeaderLines;
	m_cbColLongNameFrom.Enable = bSubHeaderLines;
	///---END SUPPORT_AUTO_HEADER_LINES
	m_btnColLongNameUpdate.Enable = m_cbColLongNameFrom.Enable;

	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//m_cbColUnitFrom.Enable = bHeaderLines;
	m_cbColUnitFrom.Enable = bSubHeaderLines;
	///---END SUPPORT_AUTO_HEADER_LINES
	m_btnColUnitUpdate.Enable = m_cbColUnitFrom.Enable;
	
	m_cbColLabelFrom.Enable = bHeaderLines;
	m_cbColLabelTo.Enable = (m_cbColLabelFrom.Enable && hli.CommentFirstLine >= 0);
	m_btnColLabelRefresh.Enable = m_cbColLabelFrom.Enable;

	m_cbColParamFrom.Enable = bHeaderLines;
	m_cbColParamTo.Enable = (m_cbColParamFrom.Enable && hli.ParamFirstLine >= 0);
	m_btnColParamUpdate.Enable = m_cbColParamFrom.Enable;

	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	m_cbColUserParamFrom.Enable = bHeaderLines;
	m_cbColUserParamTo.Enable = (m_cbColUserParamFrom.Enable && hli.UserParamFirstLine >= 0);
	m_btnColUserParamUpdate.Enable = m_cbColUserParamFrom.Enable;
	///---END SUPPORT_USER_PARAMETER
	
	m_cbSaveLineFrom.Enable = bHeaderLines;
	///---Sim 10-11-2006 FIX_ENABLE_SHOW_LINETO_BOX
	//m_cbSaveLineTo.Enable = (m_cbSaveLineFrom.Enable && hli.SaveFirstLine >= 0);
	m_cbSaveLineTo.Enable = (m_cbSaveLineFrom.Enable && hli.SaveFirstLine >= 1);
	///---END FIX_ENABLE_SHOW_LINETO_BOX
	m_btnSaveUpdate.Enable = m_cbSaveLineFrom.Enable;
	/// Hong 9/18/06 MORE_UPDATE_ACCORDING_HEADER_LINES
	m_cbColNameLabelOffset.Enable = bHeaderLines;
	/// end MORE_UPDATE_ACCORDING_HEADER_LINES
	/// end MORE_HEADER_LINE_TYPES
}

/// EJP 2005-02-16 v8.0193 QA70-7038 IMPROVE_HEADER_LINE_COLORING
void ImpWizHeadLinesPage::SetHeaderLineColor(DWORD dwColor, int nFirstLine, int nLineCount, int nSkipChars) // =0
{
	if( nLineCount == -1 ) // -1 = all lines
		nLineCount = m_reHdrPreview.GetLineCount();
	
	long nStartChar, nEndChar;

	nStartChar = m_reHdrPreview.LineIndex(nFirstLine);
	nEndChar = m_reHdrPreview.LineIndex(nFirstLine + nLineCount);
	m_reHdrPreview.SetTextColor(nStartChar, nEndChar, dwColor);
	
	if( nSkipChars )
	{
		int nLineLen;
		for( int nLine = nFirstLine; nLine < nFirstLine + nLineCount; nLine++ )
		{
			nLineLen = m_saPreviewLines[nLine].GetLength() - LINE_NUM_AND_TYPE_PREFIX_LEN;
			if( nLineLen > 0 )
			{
				nStartChar = m_reHdrPreview.LineIndex(nLine) + LINE_NUM_AND_TYPE_PREFIX_LEN;
				nEndChar = nStartChar;
				if( nSkipChars < nLineLen )
					nEndChar += nSkipChars;
				else
					nEndChar += nLineLen;
				m_reHdrPreview.SetTextColor(nStartChar, nEndChar, AIW_COLOR_SKIP_CHARS);
			}
		}
	}
}
/// end IMPROVE_HEADER_LINE_COLORING

void ImpWizHeadLinesPage::AscHdr_UpdatePreviewColor()
{
#ifdef JUNK
	//RichEdit rePreview = ImportWizDlg.GetItem(IDC_HEADER_PREVIEW, IDD_AIW_HEADER);	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
	
	if( !m_reHdrPreview )
		return;

	// Save selection
	long nSelStartChar, nSelEndChar;
	m_reHdrPreview.GetSel(nSelStartChar, nSelEndChar);
	
	/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
	UpdatePreviewLineTypes();
	UpdatePreviewText();
	/// end MORE_HEADER_LINE_TYPES
	
	long nStartChar, nEndChar;

	int iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo;
	AscHdr_GetFromDialog(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
	AscHdr_Check(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);

	// If there are header lines then color them
	if( iHeaderLines )
	{
		nEndChar = m_reHdrPreview.LineIndex(iHeaderLines);
		m_reHdrPreview.SetTextColor(0, nEndChar, AIW_COLOR_HEADER_LINES);
	
		// If there are label lines then color them
		if( iColLabelFrom >= 0 )
		{
			if( iColLabelTo < 0 )
				iColLabelTo = iHeaderLines;
	
			/// EJP 2005-02-01 v8.0187 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
			///	/// EJP 10-27-03 v7.5733 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
			///	///nStartChar = rePreview.LineIndex(iColLabelFrom);
			///	///nEndChar = rePreview.LineIndex(iColLabelTo + 1);
			///	///rePreview.SetTextColor(nStartChar, nEndChar, AIW_COLOR_COL_LABEL);
			///	for( int iLine = iColLabelFrom; iLine <= iColLabelTo; iLine++ )
			///	{
			///		nStartChar = m_reHdrPreview.LineIndex(iLine);
			///		nEndChar = m_reHdrPreview.LineIndex(iLine + 1);
			///		if( nStartChar <= nEndChar )
			///			m_reHdrPreview.SetTextColor(nStartChar, nEndChar, AIW_COLOR_COL_LABEL);
			///	}
			///	/// end SKIP_CHARS_FOR_COL_NAME_LABEL
			nStartChar = m_reHdrPreview.LineIndex(iColLabelFrom);
			nEndChar = m_reHdrPreview.LineIndex(iColLabelTo + 1);
			m_reHdrPreview.SetTextColor(nStartChar, nEndChar, AIW_COLOR_COL_LABEL);
			/// end SKIP_CHARS_FOR_COL_NAME_LABEL
		}
	
		// If there is a line for column names then color it
		if( iColNameFrom >= 0 )
		{
			/// EJP 2005-02-01 v8.0187 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
			///	/// EJP 10-27-03 v7.5733 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
			///	///nStartChar = rePreview.LineIndex(iColNameFrom);
			///	///nEndChar = rePreview.LineIndex(iColNameFrom + 1);
			///	///rePreview.SetTextColor(nStartChar, nEndChar, AIW_COLOR_COL_NAME);
			///	nStartChar = m_reHdrPreview.LineIndex(iColNameFrom) + m_pAscimp->iLabelSkipChars;
			///	nEndChar = m_reHdrPreview.LineIndex(iColNameFrom + 1);
			///	if( nStartChar <= nEndChar )
			///		m_reHdrPreview.SetTextColor(nStartChar, nEndChar, AIW_COLOR_COL_NAME);
			///	/// end SKIP_CHARS_FOR_COL_NAME_LABEL
			nStartChar = m_reHdrPreview.LineIndex(iColNameFrom);
			nEndChar = m_reHdrPreview.LineIndex(iColNameFrom + 1);
			m_reHdrPreview.SetTextColor(nStartChar, nEndChar, AIW_COLOR_COL_NAME);
			/// end SKIP_CHARS_FOR_COL_NAME_LABEL
		}

		/// EJP 2005-01-31 v8.0187 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
		if( m_pAscimp->iLabelSkipChars > 0 )
		{
			int nLineLen;
			for( int nLine = 0; nLine < iHeaderLines; nLine++ )
			{
				nLineLen = m_saPreviewLines[nLine].GetLength() - LINE_NUM_AND_TYPE_PREFIX_LEN;
				if( nLineLen > 0 )
				{
					nStartChar = m_reHdrPreview.LineIndex(nLine) + LINE_NUM_AND_TYPE_PREFIX_LEN;
					nEndChar = nStartChar;
					if( m_pAscimp->iLabelSkipChars < nLineLen )
						nEndChar += m_pAscimp->iLabelSkipChars;
					else
						nEndChar += nLineLen;
					m_reHdrPreview.SetTextColor(nStartChar, nEndChar, AIW_COLOR_DATA_LINES);
				}
			}
		}
		/// end SKIP_CHARS_FOR_COL_NAME_LABEL

		// Get char index of first data line
		nStartChar = m_reHdrPreview.LineIndex(iHeaderLines);
	}
	else
		nStartChar = 0; // first char is first data line
	nEndChar = m_reHdrPreview.LineIndex(IW_NUM_HEADER_PREVIEW_LINES);

	// Color data lines
	m_reHdrPreview.SetTextColor(nStartChar, nEndChar, AIW_COLOR_DATA_LINES);

	// Restore selection
	m_reHdrPreview.SetSel(nSelStartChar, nSelEndChar);

	int HeaderLines;
	int ShortNameFirstLine;
	int LongNameFirstLine;
	int UnitFirstLine;
	int CommentFirstLine;
	int CommentLastLine;
	int ParamFirstLine;
	int ParamLastLine;
#endif JUNK
	UpdatePreviewLineTypes();
	UpdatePreviewText();

	HEADERLINEINFO hli;
	GetHeaderLineInfo(hli);

	SetHeaderLineColor(AIW_COLOR_DATA_LINES, 0, -1); // -1 = all lines
	if( hli.HeaderLines > 0 )
	{
		SetHeaderLineColor(AIW_COLOR_HEADER_LINES, 0, hli.HeaderLines);
		SetHeaderLineColor(AIW_COLOR_SUB_HEADER_LINES, hli.HeaderLines - hli.SubHeaderLines, hli.SubHeaderLines); ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
		if( hli.UserParamFirstLine >= 0 )
			SetHeaderLineColor(AIW_COLOR_USER_PARAMETERS, hli.UserParamFirstLine, hli.UserParamLastLine - hli.UserParamFirstLine + 1, m_pAscimp->iLabelSkipChars);
		///---END SUPPORT_USER_PARAMETER
		if( hli.ParamFirstLine >= 0 )
			SetHeaderLineColor(AIW_COLOR_PARAMETERS, hli.ParamFirstLine, hli.ParamLastLine - hli.ParamFirstLine + 1, m_pAscimp->iLabelSkipChars);
		if( hli.CommentFirstLine >= 0 )
			SetHeaderLineColor(AIW_COLOR_COMMENTS, hli.CommentFirstLine, hli.CommentLastLine - hli.CommentFirstLine + 1, m_pAscimp->iLabelSkipChars);
		if( hli.UnitFirstLine >= 0 )
			SetHeaderLineColor(AIW_COLOR_UNITS, hli.UnitFirstLine, 1, m_pAscimp->iLabelSkipChars);
		if( hli.LongNameFirstLine >= 0 )
			SetHeaderLineColor(AIW_COLOR_COL_LONG_NAME, hli.LongNameFirstLine, 1, m_pAscimp->iLabelSkipChars);
		if( hli.ShortNameFirstLine >= 0 )
			SetHeaderLineColor(AIW_COLOR_COL_NAME, hli.ShortNameFirstLine, 1, m_pAscimp->iLabelSkipChars);
	}
}

bool ImpWizHeadLinesPage::OnEditChangeSaveFirstLine_AscHdr(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	AscHdr_UpdateSaveLines(); // update filter
	return TRUE;
}

bool ImpWizHeadLinesPage::OnSelChangeSaveFirstLine_AscHdr(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ComboBox cbFirstLine2(ctrl);
	//ComboBox cbLastLine = ImportWizDlg.GetItem(IDC_HDR_SAVE_TO, IDD_AIW_HEADER);///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
	
	int iSel = cbFirstLine2.GetCurSel();
	string str;
	cbFirstLine2.GetLBText(iSel, str);
	int iFirstLine, iNumLines;
	AscHdr_GetSaveLines(iFirstLine, iNumLines);
	if( 0 == str.CompareNoCase(SZ_IW_NONE) )
	{
		iFirstLine = 0;
		iNumLines = 0;
		m_cbLastLine.Enable = 0;
	}
	else if( 0 == str.CompareNoCase(SZ_IW_ALL) )
	{
		iFirstLine = 0;
		iNumLines = AscHdr_GetActualHeaderLines(); ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		m_cbLastLine.Enable = 0;
	}
	else
	{
		iFirstLine = atoi(str);
		m_cbLastLine.Enable = 1;
	}
	
	/// JCG 05/28/03 v7.0540 HOOK_COMBO_BOX	
	/// AscHdr_SetSaveLines(iFirstLine, iNumLines);
	// shouldn't update the combobox value.
	/// end HOOK_COMBO_BOX	
	
	AscHdr_SetSaveLines(iFirstLine, iNumLines, false);
	return TRUE;
}

bool ImpWizHeadLinesPage::OnSelChangeFont_AscHdr(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ComboBox cbFonts(ctrl);
	if( !cbFonts )
		return FALSE;
	int i = cbFonts.GetCurSel();
	if( -1 == i )
		return FALSE;
	m_pSheet->SetPreviewFont(cbFonts.GetItemData(i));
	//iw_SetRichEditFont(IDC_HEADER_PREVIEW, IDD_AIW_HEADER, s_iPreviewFont);	///Danice 12/12/03 v7.5780 FUNCTION_REWRITED
	iw_SetRichEditFont(IDC_HEADER_PREVIEW, IW_PREVIEW_FONT);
	AscHdr_UpdatePreviewColor();
	return TRUE;
}

void ImpWizHeadLinesPage::iw_SetRichEditFont(int iCtrl, int iFont)
{
	RichEdit re = GetItem(iCtrl);
	if( re );
		m_pSheet->iw_SetRichEditFont(re, iFont);
}

/// EJP 11-18-2004 v8.0164 QA70-6554 EXTRACT_VARS_FROM_FILENAME
/*
bool ImpWizHeadLinesPage::OnClickDefineVar_AscHeader(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	Button chkDefineVar2(ctrl);
	if( chkDefineVar2.Check )
		ENABLE_DEFINE_HDR_VAR;
	else
		DISABLE_DEFINE_HDR_VAR;
	return TRUE;
}
*/
/// end EXTRACT_VARS_FROM_FILENAME

bool ImpWizHeadLinesPage::OnEditChangeNameOffset_AscHdr(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ComboBox cbOffset(ctrl);
	if( !cbOffset )
		return FALSE;
	m_pAscimp->iLabelSkipChars = atoi(cbOffset.Text);
	if( m_pAscimp->iLabelSkipChars < 0 )
		m_pAscimp->iLabelSkipChars = 0;
	AscHdr_UpdatePreviewColor();
	return TRUE;
}

bool ImpWizHeadLinesPage::OnSelChangeNameOffset_AscHdr(Control ctrl)		///Danice 12/14/03 v7.5781 CHANGE_FUNCTION_NAME
{
	ComboBox cbOffset(ctrl);
	if( !cbOffset )
		return FALSE;
	int iCurSel = cbOffset.GetCurSel();
	if( iCurSel == -1 )
		return FALSE;
	string strCurSel;
	cbOffset.GetLBText(iCurSel, strCurSel);
	m_pAscimp->iLabelSkipChars = atoi(strCurSel);
	if( m_pAscimp->iLabelSkipChars < 0 )
		m_pAscimp->iLabelSkipChars = 0;
	AscHdr_UpdatePreviewColor();
	return TRUE;
}

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
void ImpWizHeadLinesPage::AscHeader_Update(BOOL bDataToDlg) //=TRUE)
///---END SUPPORT_AUTO_HEADER_LINES
{
	int iAutoSubHeaderLines, iSubHeaderLines; ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo;
	int iFirstLine, iNumLines;
	
	/// EJP 10-24-03 v7.5730 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
	string str;
	//ComboBox cbColNameLabelOffset = ImportWizDlg.GetItem(IDC_NAME_LABEL_CHAR_OFFSET, IDD_AIW_HEADER);	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
	/// end SKIP_CHARS_FOR_COL_NAME_LABEL

	if( bDataToDlg )
	{
		/// EJP 06-14-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//AscHdr_SetFromBottom( AscHdr_IsFromBottom(false), true); // from filter, to dialog
 		//AscHdr_GetFromASCIMP(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo, iAutoSubHeaderLines, iSubHeaderLines);
		//AscHdr_SetToDialog(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo, iAutoSubHeaderLines, iSubHeaderLines);
		//int n1, n2;
//
		//GetLongNameHeaderLine(n1, false); // false = filter
		//SetLongNameHeaderLine(n1); // dialog
		//
		//GetUnitHeaderLine(n1, false); // false = filter
		//SetUnitHeaderLine(n1); // dialog
		//
		//GetParamHeaderLine(n1, n2, false); // false = filter
		//SetParamHeaderLine(n1, n2); // dialog
		AscHdr_ASCIMPToDialog();
		///---END SUPPORT_AUTO_HEADER_LINES
		/// end MORE_HEADER_LINE_TYPES

		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
 		//AscHdr_GetFromASCIMP(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
		//AscHdr_SetToDialog(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
		///---END SUPPORT_AUTO_HEADER_LINES
		AscHdr_EnableCtrls();
		AscHdr_UpdatePreviewColor();

		///---Sim 12-20-2006 NO_NEED_SAVE_LINES
		//AscHdr_GetSaveLines(iFirstLine, iNumLines, false); // false = get data
		//AscHdr_SetSaveLines(iFirstLine, iNumLines, true); // true = set dialog
		///---END NO_NEED_SAVE_LINES

		/// EJP 11-18-2004 v8.0164 QA70-6554 EXTRACT_VARS_FROM_FILENAME
		///	//Button chkDefineVar = ImportWizDlg.GetItem(IDC_HDRPARAM_DEFINEVAR, IDD_AIW_HEADER);	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
		///	m_chkDefineVar.Check = IS_DEFINE_HDR_VAR;
		/// end EXTRACT_VARS_FROM_FILENAME
		
		/// EJP 10-24-03 v7.5730 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
		str.Format("%d", m_pAscimp->iLabelSkipChars);
		m_cbColNameLabelOffset.Text = str;
		/// end SKIP_CHARS_FOR_COL_NAME_LABEL
		
		/// EJP 2005-08-26 v8.0196 QA70-7894 USER_SPECIFY_NUM_PREVIEW_LINES
		str.Format("%d", m_pSheet->GetASCPreviewLines());
		m_cbPreviewLines.Text = str;
		/// end USER_SPECIFY_NUM_PREVIEW_LINES
	}
	else
	{
		///AscHdr_GetFromDialog(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
		///AscHdr_Check(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
		///AscHdr_SetToASCIMP(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
		AscHdr_DialogToASCIMP();
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//AscHdr_GetFromASCIMP(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
		///---END SUPPORT_AUTO_HEADER_LINES

		///---Sim 12-20-2006 NO_NEED_SAVE_LINES
		//AscHdr_GetSaveLines(iFirstLine, iNumLines); // get from dlg
		//if( iFirstLine >= iHeaderLines )
		//{
			//iFirstLine = 0;
			//iNumLines = 0;
		//}
		//if( (iFirstLine + iNumLines - 1) >= iHeaderLines )
			//iNumLines = iHeaderLines - iFirstLine;
		//AscHdr_SetSaveLines(iFirstLine, iNumLines, false); // set tree
		///---END NO_NEED_SAVE_LINES

		/// EJP 06-14-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//int n1, n2;
		//
		//GetLongNameHeaderLine(n1); // dialog
		//SetLongNameHeaderLine(n1, false); // false = filter
		//
		//GetUnitHeaderLine(n1); // dialog
		//SetUnitHeaderLine(n1, false); // false = filter
		//
		//GetParamHeaderLine(n1, n2); // dialog
		//SetParamHeaderLine(n1, n2, false); // false = filter
		//
		//AscHdr_SetFromBottom( AscHdr_IsFromBottom(true) , false); // from dialog, to filter
		///---END SUPPORT_AUTO_HEADER_LINES

		/// end MORE_HEADER_LINE_TYPES
	}
}

///---Sim 12-26-2006 NO_NEED
/*
///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
//void ImpWizHeadLinesPage::AscHdr_GetFromDialog(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo)
void ImpWizHeadLinesPage::AscHdr_GetFromDialog(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo, int& iAutoSubHeaderLines, int& iSubHeaderLines)
///---END SUPPORT_AUTO_HEADER_LINES
{
	iHeaderLines = AscHdr_GetHeaderLines();
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	AscHdr_GetSubHeaderLines(iAutoSubHeaderLines, iSubHeaderLines);
	//AscHdr_GetColLabelLines(iColLabelFrom, iColLabelTo);
	//iColNameFrom = AscHdr_GetColNameFrom();
	GetShortNameHeaderLine(iColNameFrom); // from dialog
	GetCommentHeaderLine(iColLabelFrom, iColLabelTo); // from dialog
	///---END SUPPORT_AUTO_HEADER_LINES
}
*/
///---END NO_NEED

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
//bool ImpWizHeadLinesPage::AscHdr_GetSubHeaderLines(int& iAutoSubHeaderLines, int& iSubHeaderLines)
//{
	//if( !m_chkAutoSubHeaderLines || !m_cbSubHeaderLines )
		//return false;
	//iAutoSubHeaderLines = m_chkAutoSubHeaderLines.Check;
	//iSubHeaderLines = atoi(m_cbSubHeaderLines.Text);
	//if( iSubHeaderLines < 0 )
		//iSubHeaderLines = 0;
	//return true;
//}
//
//int ImpWizHeadLinesPage::AscHdr_GetMainHeaderLines()
//{
	//int iMainHeaderLines = atoi(m_cbHeaderLines.Text);
	//if( iMainHeaderLines < 0 )
		//iMainHeaderLines = 0;
	//return iMainHeaderLines;
//}
int ImpWizHeadLinesPage::AscHdr_GetActualMainHeaderLines()
{
	return m_nMainHeaderLines;
}

int ImpWizHeadLinesPage::AscHdr_GetActualSubHeaderLines()
{
	return m_nSubHeaderLines;
}

bool ImpWizHeadLinesPage::GetAutoSubHeaderLines(int& nAutoSubHeaderLines, bool bDialog)// = true)
{
	if ( bDialog )
	{
		nAutoSubHeaderLines = m_chkAutoSubHeaderLines.Check ? 1 : 0;
	}
	else // filter
	{
		nAutoSubHeaderLines = m_pAscimp->iAutoSubHeaderLines;
	}
	return true;
}
///---END SUPPORT_AUTO_HEADER_LINES

///---Sim 12-27-2006 NO_NEED
/*
int ImpWizHeadLinesPage::AscHdr_GetHeaderLines()
{
	//ComboBox cbHeaderLines = ImportWizDlg.GetItem(IDC_IW_HEADER_LINES, IDD_AIW_HEADER);	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//int iHeaderLines = atoi(m_cbHeaderLines.Text);
	int iHeaderLines;
	iHeaderLines = m_nMainHeaderLines + m_nSubHeaderLines;
	///---END SUPPORT_AUTO_HEADER_LINES
	if( iHeaderLines < 0 )
		iHeaderLines = 0;
	return iHeaderLines;
}
*/
///---END NO_NEED

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
//bool ImpWizHeadLinesPage::AscHdr_GetColLabelLines(int &iColLabelFrom, int &iColLabelTo)
//{
	/////Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
	////ComboBox cbColLabelFrom = ImportWizDlg.GetItem(IDC_IW_COL_LABEL_FROM, IDD_AIW_HEADER);
	////ComboBox cbColLabelTo = ImportWizDlg.GetItem(IDC_HDR_LABEL_TO, IDD_AIW_HEADER);
	/////END GET_IN_INITIALIZATION
//
	//if( !m_cbColLabelFrom || !m_cbColLabelTo )
		//return false;
//
	//string str;
//
	/////---Sim 12-18-2006 FIX_BUG_OF_COMBOX_STRING_TEXT_SELECTION
	////iColLabelFrom = m_cbColLabelFrom.GetCurSel();
	////if( iColLabelFrom >= 0 )
		////m_cbColLabelFrom.GetLBText(iColLabelFrom, str);
	////else
	/////---END FIX_BUG_OF_COMBOX_STRING_TEXT_SELECTION
	//str = m_cbColLabelFrom.Text;
	//iColLabelFrom = atoi(str);
	/////---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//if ( iColLabelFrom > 0 )
		//iColLabelFrom += AscHdr_GetMainHeaderLines();
	//else
	/////---END SUPPORT_AUTO_HEADER_LINES
	//if( iColLabelFrom < 0 ) // if user setting less than zero
		//iColLabelFrom = 0; // change user setting to zero (none)
//
	//iColLabelTo = atoi(m_cbColLabelTo.Text);
	/////---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//if ( iColLabelTo > 0 )
		//iColLabelTo += AscHdr_GetMainHeaderLines();
	//else
	/////---END SUPPORT_AUTO_HEADER_LINES
	//if( iColLabelTo < 0 ) // if user setting less than zero
		//iColLabelTo = 0; // change user setting to zero (none)
//
	//iColLabelFrom--; // minus 1 for zero based line index, or (-1) for none
	//iColLabelTo--; // minus 1 for zero based line index, or (-1) for end
	//return true;
//}
///---END SUPPORT_AUTO_HEADER_LINES

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
//int ImpWizHeadLinesPage::AscHdr_GetColNameFrom()
//{
	////ComboBox cbColNameFrom = ImportWizDlg.GetItem(IDC_IW_COL_NAME_FROM, IDD_AIW_HEADER);	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
	//
	//int iColNameFrom = atoi(m_cbColNameFrom.Text);
	/////---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//if ( iColNameFrom > 0 )
	//{
		//if ( AscHdr_IsFromBottom() )
		//{
			//int nAutoHeaderLines, nSubHeaderLines;
			//AscHdr_GetSubHeaderLines(nAutoHeaderLines, nSubHeaderLines);
			//iColNameFrom = nSubHeaderLines - iColNameFrom + 1;
		//}
		//iColNameFrom += AscHdr_GetMainHeaderLines();
	//}
	//else
	/////---END SUPPORT_AUTO_HEADER_LINES
	//if( iColNameFrom < 0 ) // if user setting less than zero
		//iColNameFrom = 0; // change user setting to zero (none)
	//
	//return iColNameFrom - 1; // minus 1 for zero based line index, or (-1) for none
//}
///---END SUPPORT_AUTO_HEADER_LINES

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
//void ImpWizHeadLinesPage::AscHdr_Check(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo)
void ImpWizHeadLinesPage::AscHdr_Check(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo, int& iAutoSubHeaderLines, int& iSubHeaderLines)
///---END SUPPORT_AUTO_HEADER_LINES
{
	if( iHeaderLines )
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		if ( iHeaderLines < iSubHeaderLines )
			iHeaderLines = iSubHeaderLines;
		
		int iMainHeaderLines = iHeaderLines - iSubHeaderLines;
		///---END SUPPORT_AUTO_HEADER_LINES
		
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//if( iColLabelFrom > iColLabelTo && iColLabelTo >= 0 )
		//{
			//int i = iColLabelFrom;
			//iColLabelFrom = iColLabelTo;
			//iColLabelTo = i;
		//}
		//if( iColLabelFrom >= iHeaderLines )
		if( iColLabelFrom < iMainHeaderLines || iColLabelFrom >= iHeaderLines)
		{
			iColLabelFrom = -1;
			iColLabelTo = -1;
		}
		//else if( iColLabelTo < 0 || iColLabelTo >= iHeaderLines )
		else if( iColLabelTo < iColLabelFrom || iColLabelTo >= iHeaderLines )
		{
			iColLabelTo = iHeaderLines - 1;
		}
		///---END SUPPORT_AUTO_HEADER_LINES
		
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//if( iColNameFrom >= iHeaderLines )
		if ( iColNameFrom < iMainHeaderLines || iColNameFrom >= iHeaderLines )
			iColNameFrom = -1;
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	else // no header lines means no column names and no labels
	{
		iColNameFrom = -1;
		iColLabelFrom = -1;
		iColLabelTo = -1;
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//iAutoSubHeaderLines = 1;
		iSubHeaderLines = 0;
		///---END SUPPORT_AUTO_HEADER_LINES
	}
}

void ImpWizHeadLinesPage::AscHdr_GetSaveLines(int &iFirstLine, int &iNumLines, bool bFromDlg) //=true)
{
	int iLastLine;
	string str;
	
	if( bFromDlg )
	{
		///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
		//ComboBox cbFirstLine = ImportWizDlg.GetItem(IDC_HDR_SAVE_FROM, IDD_AIW_HEADER);
		//ComboBox cbLastLine = ImportWizDlg.GetItem(IDC_HDR_SAVE_TO, IDD_AIW_HEADER);
		///END GET_IN_INITIALIZATION

		str = m_cbFirstLine.Text;
		if( 0 == str.CompareNoCase(SZ_IW_ALL) )
		{
			iFirstLine = 0;
			iNumLines = ASCIMP_TOTAL_HEADER_LINES(m_pAscimp);
			return;
		}
		if( 0 == str.CompareNoCase(SZ_IW_NONE) )
		{
			iFirstLine = 0;
			iNumLines = 0; // none
			return;
		}
		iFirstLine = atoi(str);
		if( iFirstLine < 1 )
			iFirstLine = 1;

		str = m_cbLastLine.Text;
		if( 0 == str.CompareNoCase(SZ_IW_END) )
		{
			iNumLines = ASCIMP_TOTAL_HEADER_LINES(m_pAscimp) - iFirstLine;
			return;
		}
		iLastLine = atoi(str);
		if( iLastLine < 1 || iLastLine < iFirstLine )
			iLastLine = iFirstLine;

		iFirstLine--;
		iNumLines = iLastLine - iFirstLine;
	}
	else // from filter
	{
		if( !fuGetHdrSave(s_trFilter, iFirstLine, iNumLines) )
		{
			iFirstLine = 0;
			iNumLines = ASCIMP_TOTAL_HEADER_LINES(m_pAscimp);
			fuSetHdrSave(s_trFilter, iFirstLine, iNumLines);
		}
	}
}

void ImpWizHeadLinesPage::AscHdr_SetSaveLines(int iFirstLine, int iNumLines, bool bToDlg) //=true)
{
	if( bToDlg )
	{
		string str;
		
		///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
		//ComboBox cbFirstLine = ImportWizDlg.GetItem(IDC_HDR_SAVE_FROM, IDD_AIW_HEADER);
		//ComboBox cbLastLine = ImportWizDlg.GetItem(IDC_HDR_SAVE_TO, IDD_AIW_HEADER);
		///END GET_IN_INITIALIZATION
		
		if( iNumLines < 1 )
		{
			m_cbLastLine.Text = SZ_IW_END;
			m_cbLastLine.Enable = 0;
			str = SZ_IW_NONE;
		}
		else
		{
			str.Format("%d", iFirstLine + iNumLines);
			m_cbLastLine.Text = str;
			m_cbLastLine.Enable = 1;
			str.Format("%d", iFirstLine + 1);
		}
		m_cbFirstLine.Text = str;
	}
	else // to filter
	{
		fuSetHdrSave(s_trFilter, iFirstLine, iNumLines);
		
		/// EJP 09-24-2004 v8.0140 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP
		m_pAscimp->nFirstSave = iFirstLine;
		m_pAscimp->nNumSave = iNumLines;
		/// end IMPORT_INFO_STORAGE_CLEANUP
	}
}

/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
BOOL ImpWizHeadLinesPage::OnEditChangeLineType(Control ctrl)
{
	UpdatePreviewLineTypes();
	AscHdr_UpdatePreviewColor();
	AscHdr_EnableCtrls();
	return TRUE;
}

BOOL ImpWizHeadLinesPage::OnSelChangeLineType(Control ctrl)
{
	ComboBox cb(ctrl);
	if( !cb )
		return FALSE;
	int nCurSel = cb.GetCurSel();
	if( -1 == nCurSel )
		return FALSE;
	string strCurSel;
	cb.GetLBText(nCurSel, strCurSel);
	cb.Text = strCurSel;
	return OnEditChangeLineType(ctrl);
}

BOOL ImpWizHeadLinesPage::OnClickLineTypeUpdate(Control ctrl)
{
	int nFirstLine, nLastLine;
	GetSelLines(nFirstLine, nLastLine);

	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//string strFirstLine;
	//strFirstLine.Format("%d", nFirstLine + 1);
	//
	//string strLastLine;
	//strLastLine.Format("%d", nLastLine + 1);
	///---END SUPPORT_AUTO_HEADER_LINES
	
	int nID = GetDlgCtrlID(ctrl.GetSafeHwnd());
	switch( nID )
	{
	case IDC_IW_COL_NAME_TBHLDR: // column name
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//m_cbColNameFrom.Text = strFirstLine;
		SetShortNameHeaderLine(nFirstLine);
		///---END SUPPORT_AUTO_HEADER_LINES
		break;
	case IDC_COL_LONGNAME_UPDATE: // long column name
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//m_cbColLongNameFrom.Text = strFirstLine;
		SetLongNameHeaderLine(nFirstLine);
		///---END SUPPORT_AUTO_HEADER_LINES
		break;
	case IDC_IW_COL_LABEL_TBHLDR: // column label/comment
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//m_cbColLabelFrom.Text = strFirstLine;
		//m_cbColLabelTo.Text = strLastLine;
		SetCommentHeaderLine(nFirstLine, nLastLine);
		///---END SUPPORT_AUTO_HEADER_LINES
		break;
	case IDC_COL_UNIT_UPDATE: // column unit
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//m_cbColUnitFrom.Text = strFirstLine;
		SetUnitHeaderLine(nFirstLine);
		///---END SUPPORT_AUTO_HEADER_LINES
		break;
	case IDC_COL_PARAM_UPDATE: // column parameter
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//m_cbColParamFrom.Text = strFirstLine;
		//m_cbColParamTo.Text = strLastLine;
		SetParamHeaderLine(nFirstLine, nLastLine);
		///---END SUPPORT_AUTO_HEADER_LINES
		break;
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	case IDC_COL_USER_PARAM_UPDATE: // column user parameter
		SetUserParamHeaderLine(nFirstLine, nLastLine);
		break;
	///---END SUPPORT_USER_PARAMETER
	case IDC_SAVE_HDR_UPDATE: // save header lines
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//m_cbSaveLineFrom.Text = strFirstLine;
		//m_cbSaveLineTo.Text = strLastLine;
		///---END SUPPORT_AUTO_HEADER_LINES
		break;
	}
	UpdatePreviewLineTypes();
	AscHdr_UpdatePreviewColor();
	AscHdr_EnableCtrls();
	return TRUE;
}

void ImpWizHeadLinesPage::GetSelLines(int& nFirstLine, int& nLastLine)
{
	long nStartChar, nEndChar;
	m_reHdrPreview.GetSel(nStartChar, nEndChar);
	nFirstLine = m_reHdrPreview.LineFromChar(nStartChar);
	nLastLine = m_reHdrPreview.LineFromChar(nEndChar);
	if( nEndChar > nStartChar ) // if chars selected
	{
		if( m_reHdrPreview.LineIndex(nLastLine) == nEndChar ) // if no chars selected on last line
			nLastLine--;
	}
}

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
bool ImpWizHeadLinesPage::GetShortNameHeaderLine(int& nFirstLine, bool bDialog) //=true)
{
	if( bDialog )
	{
		nFirstLine = atoi(m_cbColNameFrom.Text);
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//if ( nFirstLine > 0 )
		//{
			//if ( AscHdr_IsFromBottom() )
			//{
				//int nAutoHeaderLines, nSubHeaderLines;
				//AscHdr_GetSubHeaderLines(nAutoHeaderLines, nSubHeaderLines);
				//nFirstLine = nSubHeaderLines - nFirstLine + 1;
			//}
			//nFirstLine += nMainHeaderLines;
		//}
		//else
		//if( nFirstLine < 0 ) // if user setting less than zero
			//nFirstLine = 0; // change user setting to zero (none)
		//nFirstLine--; // minus 1 for zero based line index, or (-1) for none
		//
		//if ( nFirstLine < nMainHeaderLines || nFirstLine >= nHeaderLines )
		//{
			//nFirstLine = -1;
		//}
		if ( IsFromBottomHeaderLines() ) // from dialog
			nFirstLine = ChangePosFromBottom(nFirstLine);
		
		nFirstLine = GetAbsolutePos(nFirstLine);
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	else // filter
	{
		//if( m_pAscimp->iRenameCols )
		//{
			//if ( m_pAscimp->iAutoSubHeaderLines )
			//{
				//nFirstLine = m_pAscimp->iRenameCols;
				//if ( AscHdr_IsFromBottom(false) ) // from filter
				//{
					//nFirstLine = m_pAscimp->iSubHeaderLines - nFirstLine + 1;
				//}
				//nFirstLine = m_pAscimp->iHeaderLines + nFirstLine - 1;
			//}
			//else
				//nFirstLine = m_pAscimp->iHeaderLines + m_pAscimp->iSubHeaderLines - m_pAscimp->iRenameCols;
		//}
		//else
			//nFirstLine = -1;
		nFirstLine = m_pAscimp->iRenameCols;
		if ( m_pAscimp->iAutoSubHeaderLines )
		{	// auto, the position of short name is default start from top
			if ( IsFromBottomHeaderLines(false) ) // from filter
				nFirstLine = ChangePosFromBottom(nFirstLine);
		}
		else
		{	// no auto, the position of short name is default start from bottom
			nFirstLine = ChangePosFromBottom(nFirstLine);
		}
		nFirstLine = GetAbsolutePos(nFirstLine);
	}
	return true;
}

bool ImpWizHeadLinesPage::SetShortNameHeaderLine(int nFirstLine, bool bDialog) //=true)
{
	int nAutoSubHeaderLines;
	GetAutoSubHeaderLines(nAutoSubHeaderLines); // from dialog
	bool bFromBottom = IsFromBottomHeaderLines(); // from dialog
	
	if( bDialog )
	{
		nFirstLine = GetRelativePos(nFirstLine);
		if ( bFromBottom )
			nFirstLine = ChangePosFromBottom(nFirstLine);
			
		if ( nFirstLine > 0 )
			m_cbColNameFrom.Text.Format("%d", nFirstLine);
		else
			m_cbColNameFrom.SetCurSel(0); // select <none>
	}
	else // filter
	{
		nFirstLine = GetRelativePos(nFirstLine);
		if ( nAutoSubHeaderLines )
		{	// auto, the position of short name is default start from top
			if ( bFromBottom )
				nFirstLine = ChangePosFromBottom(nFirstLine);
		}
		else
		{	// no auto, the position of short name is default start from bottom
			nFirstLine = ChangePosFromBottom(nFirstLine);
		}
		m_pAscimp->iRenameCols = nFirstLine;
	}
	return true;
}
///---END SUPPORT_AUTO_HEADER_LINES

bool ImpWizHeadLinesPage::GetLongNameHeaderLine(int& nFirstLine, bool bDialog) //=true)
{
	if( bDialog )
	{
		nFirstLine = atoi(m_cbColLongNameFrom.Text);
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//if ( nFirstLine > 0 )
		//{
			//if ( AscHdr_IsFromBottom() )
			//{
				//int nAutoHeaderLines, nSubHeaderLines;
				//AscHdr_GetSubHeaderLines(nAutoHeaderLines, nSubHeaderLines);
				//nFirstLine = nSubHeaderLines - nFirstLine + 1;
			//}
			//nFirstLine += nMainHeaderLines;
		//}
		//else
		//if( nFirstLine < 0 ) // if user setting less than zero
			//nFirstLine = 0; // change user setting to zero (none)
		//nFirstLine--; // minus 1 for zero based line index, or (-1) for none
		//
		//if ( nFirstLine < nMainHeaderLines || nFirstLine >= nHeaderLines )
		//{
			//nFirstLine = -1;
		//}
		if ( IsFromBottomHeaderLines() ) // from dialog
			nFirstLine = ChangePosFromBottom(nFirstLine);
		
		nFirstLine = GetAbsolutePos(nFirstLine);
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	else // filter
	{
		///fuGetLongNameHeaderLine(s_trFilter, nFirstLine);
		nFirstLine = m_pAscimp->nLongNames;
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		if ( m_pAscimp->iAutoSubHeaderLines )
		{
			//if ( 0 == nFirstLine ) // line is none
			//{
				//nFirstLine = -1;
			//}
			//else
			//{
				//if ( AscHdr_IsFromBottom(false) ) // from filter
				//{
					//nFirstLine = m_pAscimp->iSubHeaderLines - nFirstLine + 1;
				//}
				//nFirstLine = m_pAscimp->iHeaderLines + nFirstLine - 1;
			//}
			if ( IsFromBottomHeaderLines(false) ) // from filter
				nFirstLine = ChangePosFromBottom(nFirstLine);
			nFirstLine = GetAbsolutePos(nFirstLine);
		}
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	return true;
}

bool ImpWizHeadLinesPage::SetLongNameHeaderLine(int nFirstLine, bool bDialog) //=true)
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int nAutoSubHeaderLines;
	GetAutoSubHeaderLines(nAutoSubHeaderLines); // from dialog
	bool bFromBottom = IsFromBottomHeaderLines();
	///---END SUPPORT_AUTO_HEADER_LINES
	if( bDialog )
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//if( nFirstLine >= 0 )
			//m_cbColLongNameFrom.Text.Format("%d", nFirstLine + 1);
		nFirstLine = GetRelativePos(nFirstLine);
		if ( bFromBottom )
			nFirstLine = ChangePosFromBottom(nFirstLine);
			
		if ( nFirstLine > 0 )
			m_cbColLongNameFrom.Text.Format("%d", nFirstLine);
		///---END SUPPORT_AUTO_HEADER_LINES
		else
			m_cbColLongNameFrom.SetCurSel(0); // select <none>
	}
	else // filter
	{
		///fuSetLongNameHeaderLine(s_trFilter, nFirstLine);
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		AscHdr_CheckAbsolutePos(nFirstLine);
		if ( nAutoSubHeaderLines )
		{
			nFirstLine = GetRelativePos(nFirstLine);
			if ( bFromBottom )
				nFirstLine = ChangePosFromBottom(nFirstLine);
		}
		///---END SUPPORT_AUTO_HEADER_LINES
		m_pAscimp->nLongNames = nFirstLine;
	}
	return true;
}

bool ImpWizHeadLinesPage::GetUnitHeaderLine(int& nFirstLine, bool bDialog) //=true)
{
	if( bDialog )
	{
		nFirstLine = atoi(m_cbColUnitFrom.Text);
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//if ( nFirstLine > 0 )
		//{
			//if ( AscHdr_IsFromBottom() )
			//{
				//int nAutoHeaderLines, nSubHeaderLines;
				//AscHdr_GetSubHeaderLines(nAutoHeaderLines, nSubHeaderLines);
				//nFirstLine = nSubHeaderLines - nFirstLine + 1;
			//}
			//nFirstLine += nMainHeaderLines;
		//}
		//else
		//if( nFirstLine < 0 ) // if user setting less than zero
			//nFirstLine = 0; // change user setting to zero (none)
		//nFirstLine--; // minus 1 for zero based line index, or (-1) for none
		//
		//if ( nFirstLine < nMainHeaderLines || nFirstLine >= nHeaderLines )
		//{
			//nFirstLine = -1;
		//}
		if ( IsFromBottomHeaderLines() ) // from dialog
			nFirstLine = ChangePosFromBottom(nFirstLine);
		
		nFirstLine = GetAbsolutePos(nFirstLine);
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	else // filter
	{
		///fuGetUnitHeaderLine(s_trFilter, nFirstLine);
		nFirstLine = m_pAscimp->nUnits;
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		if ( m_pAscimp->iAutoSubHeaderLines )
		{
			//if ( 0 == nFirstLine ) // line is none
			//{
				//nFirstLine = -1;
			//}
			//else
			//{
				//if ( AscHdr_IsFromBottom(false) ) // from filter
				//{
					//nFirstLine = m_pAscimp->iSubHeaderLines - nFirstLine + 1;
				//}
				//nFirstLine = m_pAscimp->iHeaderLines + nFirstLine - 1;
			//}
			if ( IsFromBottomHeaderLines(false) ) // from filter
				nFirstLine = ChangePosFromBottom(nFirstLine);
			nFirstLine = GetAbsolutePos(nFirstLine);
		}
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	return true;
}

bool ImpWizHeadLinesPage::SetUnitHeaderLine(int nFirstLine, bool bDialog) //=true)
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int nAutoSubHeaderLines;
	GetAutoSubHeaderLines(nAutoSubHeaderLines); // from dialog
	bool bFromBottom = IsFromBottomHeaderLines();
	///---END SUPPORT_AUTO_HEADER_LINES
	if( bDialog )
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//if( nFirstLine >= 0 )
			//m_cbColUnitFrom.Text.Format("%d", nFirstLine + 1);
		nFirstLine = GetRelativePos(nFirstLine);
		if ( bFromBottom )
			nFirstLine = ChangePosFromBottom(nFirstLine);
			
		if ( nFirstLine > 0 )
			m_cbColUnitFrom.Text.Format("%d", nFirstLine);
		///---END SUPPORT_AUTO_HEADER_LINES
		else
			m_cbColUnitFrom.SetCurSel(0); // select <none>
	}
	else // filter
	{
		///fuSetUnitHeaderLine(s_trFilter, nFirstLine);
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		AscHdr_CheckAbsolutePos(nFirstLine);
		if ( nAutoSubHeaderLines )
		{
			nFirstLine = GetRelativePos(nFirstLine);
			if ( bFromBottom )
				nFirstLine = ChangePosFromBottom(nFirstLine);
		}
		///---END SUPPORT_AUTO_HEADER_LINES
		m_pAscimp->nUnits = nFirstLine;
	}
	return true;
}

bool ImpWizHeadLinesPage::GetParamHeaderLine(int& nFirstLine, int& nLastLine, bool bDialog) //=true)
{
	if( bDialog )
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//int nMainHeaderLines = AscHdr_GetMainHeaderLines();
		//int nHeaderLines = AscHdr_GetHeaderLines();
		//int nSubHeaderLines = nHeaderLines - nMainHeaderLines;
		
		nFirstLine = atoi(m_cbColParamFrom.Text);
		nLastLine = atoi(m_cbColParamTo.Text);
		//if ( nFirstLine <= 0 || nFirstLine > nSubHeaderLines )
		//{	// out of range
			//nLastLine = nFirstLine = 0;
		//}
		//else 
		//{	// trim and ensure the last line
			//if ( nLastLine < nFirstLine || nLastLine > nSubHeaderLines )
				//nLastLine = nSubHeaderLines;
			//
			//if ( AscHdr_IsFromBottom() ) // from dialog
			//{	// exchange head and tail
				//int nBottomFirstLine = nSubHeaderLines - nLastLine + 1;
				//int nBottomLastLine = nSubHeaderLines - nFirstLine + 1;
				//
				//nFirstLine = nBottomFirstLine;
				//nLastLine = nBottomLastLine;
			//}
		//}
		//
		/////---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		////nFirstLine = atoi(m_cbColParamFrom.Text);
		//if ( nFirstLine > 0 )
			//nFirstLine += nMainHeaderLines;
		//else
		////if( nFirstLine < 0 ) // if user setting less than zero
		/////---END SUPPORT_AUTO_HEADER_LINES
			//nFirstLine = 0; // change user setting to zero (none)
		//nFirstLine--; // minus 1 for zero based line index, or (-1) for none
		//
		/////---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		////nLastLine = atoi(m_cbColParamTo.Text);
		//if ( nLastLine > 0 )
			//nLastLine += nMainHeaderLines;
		//else
		////if( nLastLine < 0 ) // if user setting less than zero
		/////---END SUPPORT_AUTO_HEADER_LINES
			//nLastLine = 0; // change user setting to zero (none)
		//nLastLine--; // minus 1 for zero based line index, or (-1) for none
		
		AscHdr_CheckRelativePos(nFirstLine, nLastLine);
		if ( IsFromBottomHeaderLines() ) // from dialog
		{	// exchange head and tail
			ChangePosFromBottom(nFirstLine, nLastLine);
		}
		nFirstLine = GetAbsolutePos(nFirstLine);
		nLastLine = GetAbsolutePos(nLastLine);
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	else // filter
	{
		///fuGetParamHeaderLine(s_trFilter, nFirstLine, nLastLine);
		nFirstLine = m_pAscimp->nFirstParams;
		nLastLine = m_pAscimp->nFirstParams + m_pAscimp->nNumParams - 1;
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		if ( m_pAscimp->iAutoSubHeaderLines )
		{
			AscHdr_CheckRelativePos(nFirstLine, nLastLine);
			if ( IsFromBottomHeaderLines(false) ) // from filter
			{	// exchange head and tail
				ChangePosFromBottom(nFirstLine, nLastLine);
			}
			nFirstLine = GetAbsolutePos(nFirstLine);
			nLastLine = GetAbsolutePos(nLastLine);
		}
		else
			AscHdr_CheckAbsolutePos(nFirstLine, nLastLine);
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	return true;
}

bool ImpWizHeadLinesPage::SetParamHeaderLine(int nFirstLine, int nLastLine, bool bDialog) //=true)
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int nAutoSubHeaderLines;
	GetAutoSubHeaderLines(nAutoSubHeaderLines); // from dialog
	
	AscHdr_CheckAbsolutePos(nFirstLine, nLastLine);
	nFirstLine = GetRelativePos(nFirstLine);
	nLastLine = GetRelativePos(nLastLine);
	if ( IsFromBottomHeaderLines() ) // from dialog
	{	// exchange head and tail
		ChangePosFromBottom(nFirstLine, nLastLine);
	}
	///---END SUPPORT_AUTO_HEADER_LINES

	if( bDialog )
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		if( nFirstLine > 0 )
			m_cbColParamFrom.Text.Format("%d", nFirstLine);
		else
			m_cbColParamFrom.SetCurSel(0); // select <none>
		m_cbColParamTo.Text.Format("%d", nLastLine);
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	else // filter
	{
		///fuSetParamHeaderLine(s_trFilter, nFirstLine, nLastLine);
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		int nNumLines = 0;
		if ( nFirstLine > 0 )
			nNumLines = nLastLine - nFirstLine + 1;
		if ( nNumLines < 0 )
			nNumLines = 0;

		if ( !nAutoSubHeaderLines )
		{
			nFirstLine = GetAbsolutePos(nFirstLine);
		}
		
		m_pAscimp->nFirstParams = nFirstLine;
		//m_pAscimp->nNumParams = nLastLine - nFirstLine + 1;
		m_pAscimp->nNumParams = nNumLines;
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	return true;
}
///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
bool ImpWizHeadLinesPage::GetUserParamHeaderLine(int& nFirstLine, int& nLastLine, bool bDialog) //=true)
{
	if( bDialog )
	{
		nFirstLine = atoi(m_cbColUserParamFrom.Text);
		nLastLine = atoi(m_cbColUserParamTo.Text);
		AscHdr_CheckRelativePos(nFirstLine, nLastLine);
		if ( IsFromBottomHeaderLines() ) // from dialog
		{	// exchange head and tail
			ChangePosFromBottom(nFirstLine, nLastLine);
		}
		nFirstLine = GetAbsolutePos(nFirstLine);
		nLastLine = GetAbsolutePos(nLastLine);
	}
	else // filter
	{
		nFirstLine = m_pAscimp->nFirstUserParams;
		nLastLine = m_pAscimp->nFirstUserParams + m_pAscimp->nNumUserParams - 1;
		if ( m_pAscimp->iAutoSubHeaderLines )
		{
			AscHdr_CheckRelativePos(nFirstLine, nLastLine);
			if ( IsFromBottomHeaderLines(false) ) // from filter
			{	// exchange head and tail
				ChangePosFromBottom(nFirstLine, nLastLine);
			}
			nFirstLine = GetAbsolutePos(nFirstLine);
			nLastLine = GetAbsolutePos(nLastLine);
		}
		else
			AscHdr_CheckAbsolutePos(nFirstLine, nLastLine);
	}
	return true;
}

bool ImpWizHeadLinesPage::SetUserParamHeaderLine(int nFirstLine, int nLastLine, bool bDialog) //=true)
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	int nAutoSubHeaderLines;
	GetAutoSubHeaderLines(nAutoSubHeaderLines); // from dialog
	
	AscHdr_CheckAbsolutePos(nFirstLine, nLastLine);
	nFirstLine = GetRelativePos(nFirstLine);
	nLastLine = GetRelativePos(nLastLine);
	if ( IsFromBottomHeaderLines() ) // from dialog
	{	// exchange head and tail
		ChangePosFromBottom(nFirstLine, nLastLine);
	}
	///---END SUPPORT_AUTO_HEADER_LINES

	if( bDialog )
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		if( nFirstLine > 0 )
			m_cbColUserParamFrom.Text.Format("%d", nFirstLine);
		else
			m_cbColUserParamFrom.SetCurSel(0); // select <none>
		m_cbColUserParamTo.Text.Format("%d", nLastLine);
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	else // filter
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		int nNumLines = 0;
		if ( nFirstLine > 0 )
			nNumLines = nLastLine - nFirstLine + 1;
		if ( nNumLines < 0 )
			nNumLines = 0;

		if ( !nAutoSubHeaderLines )
		{
			nFirstLine = GetAbsolutePos(nFirstLine);
		}
		
		m_pAscimp->nFirstUserParams = nFirstLine;
		m_pAscimp->nNumUserParams = nNumLines;
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	return true;
}
///---END SUPPORT_USER_PARAMETER

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
bool ImpWizHeadLinesPage::GetCommentHeaderLine(int& nFirstLine, int& nLastLine, bool bDialog)//=true
{
	if( bDialog )
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//int nMainHeaderLines = AscHdr_GetMainHeaderLines();
		//int nHeaderLines = AscHdr_GetHeaderLines();
		//int nSubHeaderLines = nHeaderLines - nMainHeaderLines;
		
		nFirstLine = atoi(m_cbColLabelFrom.Text);
		nLastLine = atoi(m_cbColLabelTo.Text);
		//if ( nFirstLine <= 0 || nFirstLine > nSubHeaderLines )
		//{	// out of range
			//nLastLine = nFirstLine = 0;
		//}
		//else 
		//{	// trim and ensure the last line
			//if ( nLastLine < nFirstLine || nLastLine > nSubHeaderLines )
				//nLastLine = nSubHeaderLines;
			//
			//if ( IsFromBottomHeaderLines() ) // from dialog
			//{	// exchange head and tail
				//int nBottomFirstLine = nSubHeaderLines - nLastLine + 1;
				//int nBottomLastLine = nSubHeaderLines - nFirstLine + 1;
				//
				//nFirstLine = nBottomFirstLine;
				//nLastLine = nBottomLastLine;
			//}
		//}
		//
		/////---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		////nFirstLine = atoi(m_cbColLabelFrom.Text);
		//if ( nFirstLine > 0 )
			//nFirstLine += nMainHeaderLines;
		//else
		////if( nFirstLine < 0 ) // if user setting less than zero
		/////---END SUPPORT_AUTO_HEADER_LINES
			//nFirstLine = 0; // change user setting to zero (none)
		//nFirstLine--; // minus 1 for zero based line index, or (-1) for none
		//
		/////---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		////nLastLine = atoi(m_cbColLabelTo.Text);
		//if ( nLastLine > 0 )
			//nLastLine += nMainHeaderLines;
		//else
		////if( nLastLine < 0 ) // if user setting less than zero
		/////---END SUPPORT_AUTO_HEADER_LINES
			//nLastLine = 0; // change user setting to zero (none)
		//nLastLine--; // minus 1 for zero based line index, or (-1) for none
		//
		AscHdr_CheckRelativePos(nFirstLine, nLastLine);
		if ( IsFromBottomHeaderLines() ) // from dialog
		{	// exchange head and tail
			ChangePosFromBottom(nFirstLine, nLastLine);
		}
		nFirstLine = GetAbsolutePos(nFirstLine);
		nLastLine = GetAbsolutePos(nLastLine);
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	else // filter
	{
		nFirstLine = m_pAscimp->iLabels;
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		nLastLine = nFirstLine + m_pAscimp->iMaxLabels - 1;
		//if ( m_pAscimp->iAutoSubHeaderLines )
		//{
			AscHdr_CheckRelativePos(nFirstLine, nLastLine);
			if ( IsFromBottomHeaderLines(false) ) // from filter
			{	// exchange head and tail
				ChangePosFromBottom(nFirstLine, nLastLine);
			}
			nFirstLine = GetAbsolutePos(nFirstLine);
			nLastLine = GetAbsolutePos(nLastLine);
		//}
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	return true;
}
bool ImpWizHeadLinesPage::SetCommentHeaderLine(int nFirstLine, int nLastLine, bool bDialog)//=true)
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	AscHdr_CheckAbsolutePos(nFirstLine, nLastLine);
	nFirstLine = GetRelativePos(nFirstLine);
	nLastLine = GetRelativePos(nLastLine);
	if ( IsFromBottomHeaderLines() ) // from dialog
	{	// exchange head and tail
		ChangePosFromBottom(nFirstLine, nLastLine);
	}
	///---END SUPPORT_AUTO_HEADER_LINES
	if( bDialog )
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		if( nFirstLine > 0 )
			m_cbColLabelFrom.Text.Format("%d", nFirstLine);
		else
			m_cbColLabelFrom.SetCurSel(0); // select <none>
		m_cbColLabelTo.Text.Format("%d", nLastLine);
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	else // filter
	{
		///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		int nNumLines = 0;
		if ( nFirstLine > 0 )
			nNumLines = nLastLine - nFirstLine + 1;
		if ( nNumLines < 0 )
			nNumLines = 0;
		
		m_pAscimp->iLabels = nFirstLine;
		m_pAscimp->iMaxLabels = nNumLines;
		///---END SUPPORT_AUTO_HEADER_LINES
	}
	return true;
}
///---END SUPPORT_AUTO_HEADER_LINES


void ImpWizHeadLinesPage::GetHeaderLineInfo(HEADERLINEINFO& hli)
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//AscHdr_GetFromDialog(hli.HeaderLines, hli.ShortNameFirstLine, hli.CommentFirstLine, hli.CommentLastLine);
	//AscHdr_Check(hli.HeaderLines, hli.ShortNameFirstLine, hli.CommentFirstLine, hli.CommentLastLine);
	//AscHdr_GetFromDialog(hli.HeaderLines, hli.ShortNameFirstLine, hli.CommentFirstLine, hli.CommentLastLine, hli.AutoSubHeaderLines, hli.SubHeaderLines);
	//AscHdr_Check(hli.HeaderLines, hli.ShortNameFirstLine, hli.CommentFirstLine, hli.CommentLastLine, hli.AutoSubHeaderLines, hli.SubHeaderLines);
	GetAutoSubHeaderLines(hli.AutoSubHeaderLines);
	AscHdr_GetActualHeaderLines(&hli.HeaderLines, &hli.SubHeaderLines);
	hli.HeaderLines += hli.SubHeaderLines;
	
	GetShortNameHeaderLine(hli.ShortNameFirstLine);
	GetLongNameHeaderLine(hli.LongNameFirstLine);
	GetUnitHeaderLine(hli.UnitFirstLine);
	GetParamHeaderLine(hli.ParamFirstLine, hli.ParamLastLine);
	GetUserParamHeaderLine(hli.UserParamFirstLine, hli.UserParamLastLine);///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	GetCommentHeaderLine(hli.CommentFirstLine, hli.CommentLastLine);
	///---END SUPPORT_AUTO_HEADER_LINES
	AscHdr_GetSaveLines(hli.SaveFirstLine, hli.SaveLastLine);
	hli.SaveLastLine += hli.SaveFirstLine - 1;
}

void ImpWizHeadLinesPage::UpdatePreviewLines()
{
	m_saPreviewLines.SetSize(0);
	ReadFileLines(m_saPreviewLines, s_strDataFile, IW_NUM_HEADER_PREVIEW_LINES);

	int nLineLen;
	string str;
	
	for( int nLine = 0; nLine < m_saPreviewLines.GetSize(); nLine++ )
	{
		// The RichEdit control does wordwrapping.
		// Until we can turn it off we need to truncate the lines.
		nLineLen = m_saPreviewLines[nLine].GetLength();
		if( m_saPreviewLines[nLine].GetLength() > IW_PREVIEW_LINE_MAX_LEN )
			m_saPreviewLines[nLine].Delete(IW_PREVIEW_LINE_MAX_LEN, nLineLen - IW_PREVIEW_LINE_MAX_LEN);
		
		///---Sim 08-20-2007 ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
		/*
		// Insert line numbers.
		// Line format is: 3 digits for line number, space, 2 line type chars, 2 spaces, line text
		/// EJP 2005-02-01 v8.0187 QA70-5412 SKIP_CHARS_FOR_COL_NAME_LABEL
		///str.Format("%03d     ", nLine + 1);
		str.Format(LINE_NUM_AND_TYPE_PREFIX, nLine + 1);
		/// end SKIP_CHARS_FOR_COL_NAME_LABEL

		m_saPreviewLines[nLine].Insert(0, str);
		*/
		for ( int ii = 0; ii < LINE_NUM_AND_TYPE_PREFIX_LEN; ii++ )
		{
			m_saPreviewLines[nLine].Insert(0, ' ');
		}
		
		str.Format(LINE_NUM_PREFIX, nLine + 1);
		m_saPreviewLines[nLine].Delete(0, str.GetLength());
		m_saPreviewLines[nLine].Insert(0, str);
		///---END ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW

		m_saPreviewLines[nLine].Replace('\t', ' '); // Replace tabs with spaces
	}
}

/// EJP 2005-02-16 v8.0193 QA70-7038 IMPROVE_HEADER_LINE_COLORING
void ImpWizHeadLinesPage::ClearAllPreviewLineTypes()
{
	for( int nLine = 0; nLine < m_saPreviewLines.GetSize(); nLine++ )
	{
		///---Sim 01-26-2007 FIX_HARD_CODE_OF_CONSTANT_STRING
		//m_saPreviewLines[nLine].Delete(LINE_TYPE_FIRST, NUM_LINE_TYPES);
		//m_saPreviewLines[nLine].Insert(LINE_TYPE_FIRST, "     ");
		for ( int ii = 0; ii < NUM_LINE_TYPES; ii++ )
		{
			m_saPreviewLines[nLine].SetAt(LINE_TYPE_FIRST + ii, ' ');
		}
		///---END FIX_HARD_CODE_OF_CONSTANT_STRING
	}
}

void ImpWizHeadLinesPage::SetPreviewLineType(int nType, int nFirstLine, int nLineCount)
{
	///---Sim 08-20-2007 ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
	//if( (nType < LINE_TYPE_FIRST || LINE_TYPE_LAST < nType) ||
	if( (nType < LINE_TYPE_CHAR_FIRST || LINE_TYPE_CHAR_LAST < nType) ||
	///---END ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
		(nFirstLine < 0 || m_saPreviewLines.GetSize() <= nFirstLine) ||
		0 == nLineCount )
	{
		return;
	}
	
	char cTypeChars[] = {'S','L','U','C','P','D'}; ///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	///---Sim 08-20-2007 ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
	//char cType = cTypeChars[nType - LINE_TYPE_FIRST];
	char cType = cTypeChars[nType - LINE_TYPE_CHAR_FIRST];
	///---END ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW

	if( nLineCount < 0 )
		nLineCount = m_saPreviewLines.GetSize() - nFirstLine;

	int nLastLine = nFirstLine + nLineCount - 1;
	if( nLastLine >= m_saPreviewLines.GetSize() )
		///---Sim 01-26-2007 CORRECT_LAST_LINE
		//nLastLine = m_saPreviewLines.GetSize() - nFirstLine;
		nLastLine = m_saPreviewLines.GetSize() - 1;
		///---END CORRECT_LAST_LINE
	
	for( int nLine = nFirstLine; nLine <= nLastLine; nLine++ )
		m_saPreviewLines[nLine].SetAt(nType, cType);
}
/// end IMPROVE_HEADER_LINE_COLORING

///---Sim 08-20-2007 ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
void ImpWizHeadLinesPage::SetPreviewHeaderLineType(int nType, int nFirstLine, int nLineCount)
{
	if( (nType < MAIN_HEADER_LINE || SUB_HEADER_LINE < nType) ||
		(nFirstLine < 0 || m_saPreviewLines.GetSize() <= nFirstLine) ||
		0 == nLineCount )
	{
		return;
	}
	
	if( nLineCount < 0 )
		nLineCount = m_saPreviewLines.GetSize() - nFirstLine;

	int nLastLine = nFirstLine + nLineCount - 1;
	if( nLastLine >= m_saPreviewLines.GetSize() )
		nLastLine = m_saPreviewLines.GetSize() - 1;
	
	char cTypeChars[] = {'M','S'}; // MAIN_HEADER_LINE = 0, SUB_HEADER_LINE = 1
	char cType = cTypeChars[nType];

	string str;
	for( int nLine = nFirstLine, ii = 0; nLine <= nLastLine; nLine++, ii++ )
	{
		str.Format(HEADER_LINE_NUM_PREFIX, ii+1, cType);
		m_saPreviewLines[nLine].Delete(LINE_TYPE_HEADER_FIRST, str.GetLength());
		m_saPreviewLines[nLine].Insert(LINE_TYPE_HEADER_FIRST, str);
	}
}
///---END ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW

void ImpWizHeadLinesPage::UpdatePreviewLineTypes()
{
	HEADERLINEINFO hli;
	GetHeaderLineInfo(hli);
#ifdef JUNK /// EJP 2005-02-16 v8.0193 QA70-7038 IMPROVE_HEADER_LINE_COLORING
	for( int nLine = 0; nLine < m_saPreviewLines.GetSize(); nLine++ )
	{
		if( nLine < hli.HeaderLines )
			m_saPreviewLines[nLine].SetAt(4, 'H');
		else
			m_saPreviewLines[nLine].SetAt(4, ' ');
	}
	if( hli.CommentFirstLine >= 0 )
	{
		for( int nLine = hli.CommentFirstLine; nLine <= hli.CommentLastLine; nLine++ )
			m_saPreviewLines[nLine].SetAt(4, 'C');
	}
	if( hli.ParamFirstLine >= 0 )
	{
		for( int nLine = hli.ParamFirstLine; nLine <= hli.ParamLastLine; nLine++ )
			m_saPreviewLines[nLine].SetAt(4, 'P');
	}
	if( hli.ShortNameFirstLine >= 0 )
		m_saPreviewLines[hli.ShortNameFirstLine].SetAt(4, 'S');
	if( hli.LongNameFirstLine >= 0 )
	{
		if( hli.LongNameFirstLine == hli.ShortNameFirstLine )
			m_saPreviewLines[hli.LongNameFirstLine].SetAt(5, 'L');
		else
			m_saPreviewLines[hli.LongNameFirstLine].SetAt(4, 'L');
	}
	if( hli.UnitFirstLine >= 0 )
		m_saPreviewLines[hli.UnitFirstLine].SetAt(4, 'U');
/// EJP 2005-02-16 v8.0193 QA70-7038 IMPROVE_HEADER_LINE_COLORING
#endif // JUNK
	ClearAllPreviewLineTypes();
	if( hli.HeaderLines > 0 )
	{
		///---Sim 08-20-2007 ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
		int nMainHeaderLines = hli.HeaderLines - hli.SubHeaderLines;
		SetPreviewHeaderLineType(MAIN_HEADER_LINE, 0, nMainHeaderLines);
		SetPreviewHeaderLineType(SUB_HEADER_LINE, nMainHeaderLines, hli.SubHeaderLines);
		///---END ADD_HEADER_LINE_NUM_LABEL_ON_PREVIEW
		
		SetPreviewLineType(LINE_TYPE_CHAR_OFFSET_SHORT_NAME, hli.ShortNameFirstLine);
		SetPreviewLineType(LINE_TYPE_CHAR_OFFSET_LONG_NAME, hli.LongNameFirstLine);
		SetPreviewLineType(LINE_TYPE_CHAR_OFFSET_UNIT, hli.UnitFirstLine);
		SetPreviewLineType(LINE_TYPE_CHAR_OFFSET_COMMENT, hli.CommentFirstLine, hli.CommentLastLine - hli.CommentFirstLine + 1);
		SetPreviewLineType(LINE_TYPE_CHAR_OFFSET_PARAMETER, hli.ParamFirstLine, hli.ParamLastLine - hli.ParamFirstLine + 1);
		///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
		SetPreviewLineType(LINE_TYPE_CHAR_OFFSET_USER_PARAMETER, hli.UserParamFirstLine, hli.UserParamLastLine - hli.UserParamFirstLine + 1);
		///---END SUPPORT_USER_PARAMETER
	}
/// end IMPROVE_HEADER_LINE_COLORING
}

void ImpWizHeadLinesPage::UpdatePreviewText()
{
	string str;

	for( int nLine = 0; nLine < m_saPreviewLines.GetSize(); nLine++ )
	{
		str += m_saPreviewLines[nLine];
		str += "\n";
	}
	m_reHdrPreview.Text = str;
}
/// end MORE_HEADER_LINE_TYPES

void ImpWizHeadLinesPage::AscHdr_UpdatePreviewText()
{
	/// EJP 06-10-2004 v8.0888 QA70-6523 MORE_HEADER_LINE_TYPES
	/*
	string str;
	
	/// EJP 08-29-2003 v7.5680 TRUNC_LONG_LINES_IN_HEADER_PREVIEW
	/// This code may change again if we get the RichEdit control to stop wordwrapping.
	///if( LoadTextFile(str, s_strDataFile, IW_NUM_HEADER_PREVIEW_LINES) )
	///	iwDataFileErrorMsgBox();
	StringArray saLines;
	ReadFileLines(saLines, s_strDataFile, IW_NUM_HEADER_PREVIEW_LINES);
	for( int iLine = 0; iLine < saLines.GetSize(); iLine++ )
	{
		int iLineLen = saLines[iLine].GetLength();
		if( iLineLen > IW_PREVIEW_LINE_MAX_LEN )
			saLines[iLine].Delete(IW_PREVIEW_LINE_MAX_LEN, iLineLen - IW_PREVIEW_LINE_MAX_LEN);
///		printf("line %d trunc from %d to %d\n", iLine, iLineLen, saLines[iLine].GetLength());
		str += saLines[iLine];
		str += "\n";
	}
	str.Replace('\t', ' '); // Replace tabs with spaces
	/// end TRUNC_LONG_LINES_IN_HEADER_PREVIEW

	//RichEdit reHdrPreview = ImportWizDlg.GetItem(IDC_HEADER_PREVIEW, IDD_AIW_HEADER);	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION
	
	m_reHdrPreview.Text = str;
	*/
	UpdatePreviewLines();
	/// Hong 9/14/06 QA70-5417 FIX_ERROR_COLOR_PREVIEW_WHEN_CHANGE_PREVIEW_LINES
	/*
	UpdatePreviewLineTypes();
	UpdatePreviewText();
	*/
	AscHdr_UpdatePreviewColor();
	/// end FIX_ERROR_COLOR_PREVIEW_WHEN_CHANGE_PREVIEW_LINES
	/// end MORE_HEADER_LINE_TYPES
}

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
void ImpWizHeadLinesPage::AscHdr_DialogToASCIMP()
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//int iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo;
	//int iAutoSubHeaderLines, iSubHeaderLines;
	////AscHdr_GetFromDialog(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
	////AscHdr_Check(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
	////AscHdr_SetToASCIMP(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo);
	//AscHdr_GetFromDialog(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo, iAutoSubHeaderLines, iSubHeaderLines);
	//AscHdr_Check(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo, iAutoSubHeaderLines, iSubHeaderLines);
	//AscHdr_SetToASCIMP(iHeaderLines, iColNameFrom, iColLabelFrom, iColLabelTo, iAutoSubHeaderLines, iSubHeaderLines);
	int nAutoSubHeaderLines, nMainHeaderLines, nSubHeaderLines;
	int nShortName, nLongName, nUnitName;
	int nParaFrom, nParaTo;
	int nUserParaFrom, nUserParaTo; ///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	int nCommentFrom, nCommentTo;
	
	GetHeaderLines(nMainHeaderLines, nSubHeaderLines, nAutoSubHeaderLines, true); // from dialog
	SetHeaderLines(nMainHeaderLines, nSubHeaderLines, nAutoSubHeaderLines, false); // to filter
	SetFromBottomHeaderLines(IsFromBottomHeaderLines(true), false); // from dialog, to filter

	GetShortNameHeaderLine(nShortName, true); // from dialog
	SetShortNameHeaderLine(nShortName, false); // to filter
	
	GetLongNameHeaderLine(nLongName, true); // from dialog
	SetLongNameHeaderLine(nLongName, false); // to filter
	
	GetUnitHeaderLine(nUnitName, true); // from dialog
	SetUnitHeaderLine(nUnitName, false); // to filter
	
	GetParamHeaderLine(nParaFrom, nParaTo, true); // from dialog
	SetParamHeaderLine(nParaFrom, nParaTo, false); // to filter
	
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	GetUserParamHeaderLine(nUserParaFrom, nUserParaTo, true); // from dialog
	SetUserParamHeaderLine(nUserParaFrom, nUserParaTo, false); // to filter
	///---END SUPPORT_USER_PARAMETER
	
	GetCommentHeaderLine(nCommentFrom, nCommentTo, true); // from dialog
	SetCommentHeaderLine(nCommentFrom, nCommentTo, false); // to filter
	///---END SUPPORT_AUTO_HEADER_LINES
}

void ImpWizHeadLinesPage::AscHdr_ASCIMPToDialog()
{
	int nAutoSubHeaderLines, nMainHeaderLines, nSubHeaderLines;
	int nShortName, nLongName, nUnitName;
	int nParaFrom, nParaTo;
	int nUserParaFrom, nUserParaTo; ///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	int nCommentFrom, nCommentTo;
	
	// must update these first. long name, unit and other will base on these parameters.
	GetHeaderLines(nMainHeaderLines, nSubHeaderLines, nAutoSubHeaderLines, false); // from filter
	SetHeaderLines(nMainHeaderLines, nSubHeaderLines, nAutoSubHeaderLines, true); // to dialog
	AscHdr_SetActualHeaderLinesByAuto(nMainHeaderLines, nSubHeaderLines, nAutoSubHeaderLines);
	SetFromBottomHeaderLines(IsFromBottomHeaderLines(false), true); // from filter, to dialog

	GetShortNameHeaderLine(nShortName, false); // from filter
	SetShortNameHeaderLine(nShortName, true); // to dialog
	
	GetLongNameHeaderLine(nLongName, false); // from filter
	SetLongNameHeaderLine(nLongName, true); // to dialog
	
	GetUnitHeaderLine(nUnitName, false); // from filter
	SetUnitHeaderLine(nUnitName, true); // to dialog
	
	GetParamHeaderLine(nParaFrom, nParaTo, false); // from filter
	SetParamHeaderLine(nParaFrom, nParaTo, true); // to dialog
	
	///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
	GetUserParamHeaderLine(nUserParaFrom, nUserParaTo, false); // from filter
	SetUserParamHeaderLine(nUserParaFrom, nUserParaTo, true); // to dialog
	///---END SUPPORT_USER_PARAMETER
	
	GetCommentHeaderLine(nCommentFrom, nCommentTo, false); // from filter
	SetCommentHeaderLine(nCommentFrom, nCommentTo, true); // to dialog
}
///---END SUPPORT_AUTO_HEADER_LINES

///---Sim 12-26-2006 NO_NEED
/*
///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
//void ImpWizHeadLinesPage::AscHdr_SetToASCIMP(int iHeaderLines, int iColNameFrom, int iColLabelFrom, int iColLabelTo)
void ImpWizHeadLinesPage::AscHdr_SetToASCIMP(int iHeaderLines, int iColNameFrom, int iColLabelFrom, int iColLabelTo, int iAutoSubHeaderLines = 1, int iSubHeaderLines = 0)
///---END SUPPORT_AUTO_HEADER_LINES
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//m_pAscimp->iAutoSubHeaderLines = 0;
	m_pAscimp->iAutoSubHeaderLines = iAutoSubHeaderLines;
	m_pAscimp->iSubHeaderLines = iSubHeaderLines;
	int iMainHeaderLines = iHeaderLines - iSubHeaderLines;
	m_pAscimp->iHeaderLines = iMainHeaderLines;
	///---END SUPPORT_AUTO_HEADER_LINES

	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//if( iColNameFrom >= 0 )
	//{
		//if ( iAutoSubHeaderLines )
		//{
			//m_pAscimp->iRenameCols = iColNameFrom - iMainHeaderLines + 1;
			////if ( AscHdr_IsFromBottom() )
				////m_pAscimp->iRenameCols = iSubHeaderLines - m_pAscimp->iRenameCols + 1;
		//}
		//else
			//m_pAscimp->iRenameCols = iHeaderLines - iColNameFrom;
	//}
	//else
		//m_pAscimp->iRenameCols = 0;
	SetShortNameHeaderLine(iColNameFrom, false); // to filter
	///---END SUPPORT_AUTO_HEADER_LINES
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//if( iColLabelFrom >= 0 )
	//{
		//
		////m_pAscimp->iSubHeaderLines = iHeaderLines - iColLabelFrom; ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES remove
		/////---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		//m_pAscimp->iMaxLabels = iColLabelTo - iColLabelFrom + 1;
		////m_pAscimp->iLabels = 1;
		//m_pAscimp->iLabels = iColLabelFrom - iMainHeaderLines + 1;
		/////---END SUPPORT_AUTO_HEADER_LINES
	//}
	//else
	//{
		////m_pAscimp->iSubHeaderLines = 0;  ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES remove
		//m_pAscimp->iMaxLabels = 0;
		//m_pAscimp->iLabels = 0;
	//}
	SetCommentHeaderLine(iColLabelFrom, iColLabelTo, false); // to filter;
	///---END SUPPORT_AUTO_HEADER_LINES
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//m_pAscimp->iHeaderLines = iHeaderLines - m_pAscimp->iSubHeaderLines;
	///---END SUPPORT_AUTO_HEADER_LINES
}

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
//void ImpWizHeadLinesPage::AscHdr_GetFromASCIMP(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo)
void ImpWizHeadLinesPage::AscHdr_GetFromASCIMP(int& iHeaderLines, int& iColNameFrom, int& iColLabelFrom, int& iColLabelTo, int& iAutoSubHeaderLines, int& iSubHeaderLines)
///---END SUPPORT_AUTO_HEADER_LINES
{
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	iAutoSubHeaderLines = m_pAscimp->iAutoSubHeaderLines;
	//if ( !iAutoSubHeaderLines )
	//{
		iHeaderLines = m_pAscimp->iHeaderLines + m_pAscimp->iSubHeaderLines;
		iSubHeaderLines = m_pAscimp->iSubHeaderLines;
	//}
	//else
	//{
		//iHeaderLines = m_pAscimp->iHeaderLines;
		//GetHeaderLinesByAuto(iHeaderLines, iSubHeaderLines);
		//iHeaderLines += iSubHeaderLines;
	//}
	///---END SUPPORT_AUTO_HEADER_LINES
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//if( m_pAscimp->iRenameCols )
	//{
		//if ( iAutoSubHeaderLines )
		//{
			//iColNameFrom = m_pAscimp->iRenameCols;
			//if ( AscHdr_IsFromBottom(false) ) // from filter
			//{
				//iColNameFrom = m_pAscimp->iSubHeaderLines - iColNameFrom + 1;
			//}
			//iColNameFrom = m_pAscimp->iHeaderLines + iColNameFrom - 1;
		//}
		//else
			//iColNameFrom = iHeaderLines - m_pAscimp->iRenameCols;
	//}
	//else
		//iColNameFrom = -1;
	GetShortNameHeaderLine(iColNameFrom, false); // from filter
	///---END SUPPORT_AUTO_HEADER_LINES

	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//if( m_pAscimp->iLabels )
	//{
		/////---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
		////iColLabelFrom = iHeaderLines - m_pAscimp->iSubHeaderLines;
		////iColLabelTo = m_pAscimp->iMaxLabels + (iColLabelFrom - 1);
		//iColLabelFrom = m_pAscimp->iHeaderLines + m_pAscimp->iLabels - 1;
		//iColLabelTo = iColLabelFrom + m_pAscimp->iMaxLabels - 1;
		/////---END SUPPORT_AUTO_HEADER_LINES
	//}
	//else
	//{
		//iColLabelFrom = -1;
		//iColLabelTo = -1;
	//}
	GetCommentHeaderLine(iColLabelFrom, iColLabelTo, false); // from filter
	///---END SUPPORT_AUTO_HEADER_LINES
}

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
//void ImpWizHeadLinesPage::AscHdr_SetToDialog(int iHeaderLines, int iColNameFrom, int iColLabelFrom, int iColLabelTo)
void ImpWizHeadLinesPage::AscHdr_SetToDialog(int iHeaderLines, int iColNameFrom, int iColLabelFrom, int iColLabelTo, int iAutoSubHeaderLines = 1, int iSubHeaderLines = 0)
///---END SUPPORT_AUTO_HEADER_LINES
{
	string str, str2;

	////////// Header Lines

	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//str.Format("%d", iHeaderLines);
	int iMainHeaderLines = iHeaderLines - iSubHeaderLines;
	str.Format("%d", iMainHeaderLines);
	///---END SUPPORT_AUTO_HEADER_LINES
	///Danice 12/14/03 v7.5780 GET_IN_INITIALIZATION	
	//ComboBox cbHeaderLines = ImportWizDlg.GetItem(IDC_IW_HEADER_LINES, IDD_AIW_HEADER);
	
	m_cbHeaderLines.Text = str;
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	m_chkAutoSubHeaderLines.Check = ( 0 == iAutoSubHeaderLines ) ? 0 : 1;

	str.Format("%d", iSubHeaderLines);
	m_cbSubHeaderLines.Text = str;
	///---END SUPPORT_AUTO_HEADER_LINES
	
	////////// Column Names
	
	//ComboBox cbColNameFrom = ImportWizDlg.GetItem(IDC_IW_COL_NAME_FROM, IDD_AIW_HEADER);
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//iColNameFrom -= iMainHeaderLines; ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//if( iColNameFrom >= 0 )
		//str.Format("%d", iColNameFrom + 1);
	//else
		//str = SZ_IW_NONE;
	//m_cbColNameFrom.Text = str;
	SetShortNameHeaderLine(iColNameFrom); // to dialog
	///---END SUPPORT_AUTO_HEADER_LINES
	
	////////// Column Labels
	
	//ComboBox cbColLabelFrom = ImportWizDlg.GetItem(IDC_IW_COL_LABEL_FROM, IDD_AIW_HEADER);
	//ComboBox cbColLabelTo = ImportWizDlg.GetItem(IDC_HDR_LABEL_TO, IDD_AIW_HEADER);
	///END GET_IN_INITIALIZATION
	
	///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//iColLabelFrom -= iMainHeaderLines; ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//iColLabelTo -= iMainHeaderLines; ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
	//if( iColLabelFrom >= 0 )
	//{
		//str.Format("%d", iColLabelFrom + 1);
		//if( iColLabelFrom >= 0 )
			//str2.Format("%d", iColLabelTo + 1);
		//else
			//str2 = SZ_IW_END;
	//}
	//else
	//{
		//str = SZ_IW_NONE;
		//str2 = SZ_IW_END;
	//}
	//m_cbColLabelFrom.Text = str;
	//m_cbColLabelTo.Text = str2;
	SetCommentHeaderLine(iColLabelFrom, iColLabelTo); // to dialog
	///---END SUPPORT_AUTO_HEADER_LINES
}
*/
///---END NO_NEED

void ImpWizHeadLinesPage::AscHdr_UpdateSaveLines(bool bUpdateData) //=true)
{
	int iFirstLine, iNumLines;
	if( bUpdateData )
	{
		AscHdr_GetSaveLines(iFirstLine, iNumLines); // from dialog
		AscHdr_SetSaveLines(iFirstLine, iNumLines, false); // to filter
	}
	else
	{
		AscHdr_GetSaveLines(iFirstLine, iNumLines, false); // from filter
		AscHdr_SetSaveLines(iFirstLine, iNumLines); // to dialog
	}
}

/// EJP 2005-08-26 v8.0196 QA70-7894 USER_SPECIFY_NUM_PREVIEW_LINES
BOOL ImpWizHeadLinesPage::OnEditPreviewLines(Control ctrl)
{
	string str = m_cbPreviewLines.Text;
	int nPreviewLines = atoi(str);
	m_pSheet->SetASCPreviewLines(nPreviewLines);
	AscHdr_UpdatePreviewText();
	return TRUE;
}

BOOL ImpWizHeadLinesPage::OnSelPreviewLines(Control ctrl)
{
	int nSel = m_cbPreviewLines.GetCurSel();
	if( nSel < 0 )
		return FALSE;
	string str;
	m_cbPreviewLines.GetLBText(nSel, str);
	int nPreviewLines = atoi(str);
	m_pSheet->SetASCPreviewLines(nPreviewLines);
	AscHdr_UpdatePreviewText();
	return TRUE;
}
/// end USER_SPECIFY_NUM_PREVIEW_LINES

///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
bool ImpWizHeadLinesPage::IsFromBottomHeaderLines(bool bDialog)//=true)
{
	if ( bDialog )
	{
		return m_chkLineNumberFromBottom.Check;
	}
	else // from filter
	{
		return (m_pAscimp->flags & AI_FLAG_START_FROM_BOTTOM);
	}
}

bool ImpWizHeadLinesPage::SetFromBottomHeaderLines(bool bValue, bool bDialog)//=true)
{
	if ( bDialog )
	{
		m_chkLineNumberFromBottom.Check = (bValue)? 1 : 0;
	}
	else // from filter
	{
		m_pAscimp->flags &= ~AI_FLAG_START_FROM_BOTTOM;
		if ( bValue )
			m_pAscimp->flags |= AI_FLAG_START_FROM_BOTTOM;
	}
	return true;
}

int ImpWizHeadLinesPage::AscHdr_GetActualHeaderLines(int* pnMainHeaderLines, int* pnSubHeaderLines)// = NULL, NULL
{
	if ( NULL != pnMainHeaderLines )
		*pnMainHeaderLines = m_nMainHeaderLines;
	if ( NULL != pnSubHeaderLines )
		*pnSubHeaderLines = m_nSubHeaderLines;
	
	return m_nMainHeaderLines + m_nSubHeaderLines;
}

void ImpWizHeadLinesPage::AscHdr_SetActualHeaderLinesByAuto(int nMainHeaderLines, int nSubHeaderLines, int nAutoSubHeaderLines) // = 1
{
	if ( !nAutoSubHeaderLines )
	{	// no auto, directly pass the number of header lines
		m_nMainHeaderLines = nMainHeaderLines;
		m_nSubHeaderLines = nSubHeaderLines;
	}
	else
	{	// auto header, need detect the number of header lines from current file
		/// Hong 09/21/07 QA80-9206 FIX_AUTO_HEADERLINE_NOT_UPDATE_REALTIME
		//ASCIMP ascimp;
		//string strDataFile = m_pSheet->GetFileName();
		//AscImpReadFileStruct(strDataFile, &ascimp);
		ASCIMP ascimp;
		ascimp = *m_pAscimp;
		string strDataFile = m_pSheet->GetFileName();
		AscImpReadFileStruct(strDataFile, &ascimp, AIRF_USE_ASCIMP);
		/// end FIX_AUTO_HEADERLINE_NOT_UPDATE_REALTIME
		///---Sim 01-24-2007 MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
		//if ( nMainHeaderLines <= ascimp.iHeaderLines )
		//{
			//m_nMainHeaderLines = ascimp.iHeaderLines;
			//m_nSubHeaderLines = ascimp.iSubHeaderLines;
		//}
		//else
		//{
			//m_nMainHeaderLines = nMainHeaderLines;
			//m_nSubHeaderLines = ascimp.iHeaderLines + ascimp.iSubHeaderLines - nMainHeaderLines;
			//if ( m_nSubHeaderLines < 0 )
				//m_nSubHeaderLines = 0;
		//}
		m_nMainHeaderLines = ascimp.iHeaderLines;
		m_nSubHeaderLines = ascimp.iSubHeaderLines;
		///---END MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
	}
}

void ImpWizHeadLinesPage::AscHdr_CheckAbsolutePos(int& nAbsolPos)
{
	int nMainHeaderLines, nSubHeaderLines;
	AscHdr_GetActualHeaderLines(&nMainHeaderLines, &nSubHeaderLines);

	if ( (nAbsolPos < nMainHeaderLines) ||
		((nMainHeaderLines + nSubHeaderLines - 1) < nAbsolPos) )
	{	
		nAbsolPos = -1; // out of range
	}
}

void ImpWizHeadLinesPage::AscHdr_CheckAbsolutePos(int& nAbsolFirstPos, int& nAbsolLastPos)
{
	int nMainHeaderLines, nSubHeaderLines;
	int nHeaderLines = AscHdr_GetActualHeaderLines(&nMainHeaderLines, &nSubHeaderLines);

	if (( nAbsolFirstPos < nMainHeaderLines && nAbsolLastPos < nMainHeaderLines ) ||
		( nHeaderLines <= nAbsolFirstPos && nHeaderLines <= nAbsolLastPos ) ||
		( nAbsolLastPos < nAbsolFirstPos ) )
	{	// out of range		
		nAbsolFirstPos = nAbsolLastPos = -1;
	}
	else
	{	// trim the first and last position
		if ( nAbsolFirstPos < nMainHeaderLines )
			nAbsolFirstPos = nMainHeaderLines;
		if ( nHeaderLines <= nAbsolLastPos )
			nAbsolLastPos = nHeaderLines - 1;
	}
}

void ImpWizHeadLinesPage::AscHdr_CheckRelativePos(int& nRelatFirstPos, int& nRelatLastPos)
{
	int nSubHeaderLines = AscHdr_GetActualSubHeaderLines();
	
	if ( nRelatFirstPos <= 0 || nSubHeaderLines < nRelatFirstPos ) // check first position
	{
		nRelatFirstPos = nRelatLastPos = 0;
	}
	else
	{
		if ( nRelatLastPos < nRelatFirstPos || nSubHeaderLines < nRelatLastPos ) // check last position
		{
			nRelatLastPos = nSubHeaderLines;
		}
	}
}
	
int ImpWizHeadLinesPage::GetAbsolutePos(int nRelatPos)
{
	int nMainHeaderLines, nSubHeaderLines;
	AscHdr_GetActualHeaderLines(&nMainHeaderLines, &nSubHeaderLines);

	int nAbslPos = -1;
	if ( 1 <= nRelatPos && nRelatPos <= nSubHeaderLines )
	{
		nAbslPos = nMainHeaderLines + nRelatPos - 1;
	}
	return nAbslPos;
}

int ImpWizHeadLinesPage::GetRelativePos(int nAbsolPos)
{
	int nMainHeaderLines, nSubHeaderLines;
	AscHdr_GetActualHeaderLines(&nMainHeaderLines, &nSubHeaderLines);

	int nRelatPos = 0;
	nAbsolPos -= nMainHeaderLines;
	if ( 0 <= nAbsolPos && nAbsolPos <= (nSubHeaderLines - 1) )
	{
		nRelatPos = nAbsolPos + 1;
	}
	
	return nRelatPos;
}

int ImpWizHeadLinesPage::ChangePosFromBottom(int nRelatPos)
{
	int nSubHeaderLines = AscHdr_GetActualSubHeaderLines();
	
	int nRelatPosFromBottom = 0;
	if ( 1 <= nRelatPos && nRelatPos <= nSubHeaderLines )
	{
		nRelatPosFromBottom = nSubHeaderLines - nRelatPos + 1;
	}
	return nRelatPosFromBottom;
}

bool ImpWizHeadLinesPage::ChangePosFromBottom(int& nRelatFirstPos, int& nRelatLastPos)
{
	//AscHdr_CheckRelativePos(nRelatFirstPos, nRelatLastPos);
	
	if ( 0 == nRelatFirstPos || 0 == nRelatLastPos) // position is invalid
	{
		nRelatFirstPos = nRelatLastPos = 0;
		return false;
	}
	
	int nBottomFirstLine = ChangePosFromBottom(nRelatLastPos);
	int nBottomLastLine = ChangePosFromBottom(nRelatFirstPos);
	nRelatFirstPos = nBottomFirstLine;
	nRelatLastPos = nBottomLastLine;
	
	return true;
}


bool ImpWizHeadLinesPage::GetHeaderLines(int& nMainHeaderLines, int& nSubHeaderLines, int& nAutoSubHeaderLines, bool bDialog)// = true)
{
	if ( bDialog )
	{
		nMainHeaderLines = atoi(m_cbHeaderLines.Text);
		nSubHeaderLines = atoi(m_cbSubHeaderLines.Text);
		nAutoSubHeaderLines = m_chkAutoSubHeaderLines.Check ? 1 : 0;
	}
	else // filter
	{
		nMainHeaderLines = m_pAscimp->iHeaderLines;
		nSubHeaderLines = m_pAscimp->iSubHeaderLines;
		nAutoSubHeaderLines = m_pAscimp->iAutoSubHeaderLines;
	}
	///---Sim 01-24-2007 MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
	if ( nAutoSubHeaderLines )
	{
		nMainHeaderLines = 0;
		nSubHeaderLines = 0;
	}
	///---END MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
	return true;
}
bool ImpWizHeadLinesPage::SetHeaderLines(int nMainHeaderLines, int nSubHeaderLines, int nAutoSubHeaderLines, bool bDialog)// = true)
{
	if ( bDialog )
	{
		///---Sim 01-24-2007 MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
		if ( nAutoSubHeaderLines )
		{
			AscHdr_SetActualHeaderLinesByAuto(0, 0, nAutoSubHeaderLines);
			AscHdr_GetActualHeaderLines(&nMainHeaderLines, &nSubHeaderLines);
		}
		///---END MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
		m_cbHeaderLines.Text.Format("%d", nMainHeaderLines);
		m_cbSubHeaderLines.Text.Format("%d", nSubHeaderLines);
		m_chkAutoSubHeaderLines.Check = nAutoSubHeaderLines ? 1 : 0;
	}
	else // filter
	{
		/// Hong 02/08/07 FIX_FAIL_GET_HEADER_LINE_IN_EXTRACT_VARIABLE_WEHN_AUTO
		/*	we should let VC code to ignore this two parameters when auto, but not clean it here
		///---Sim 01-24-2007 MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
		if ( nAutoSubHeaderLines )
		{
			nMainHeaderLines = 0;
			nSubHeaderLines = 0;
		}
		///---END MAIN_HEADER_LINES_ALWAYS_START_FROM_BEGIN_OF_FILE
		*/
		if ( nAutoSubHeaderLines )
		{
			nMainHeaderLines = m_nMainHeaderLines;
			nSubHeaderLines = m_nSubHeaderLines;
		}
		/// end FIX_FAIL_GET_HEADER_LINE_IN_EXTRACT_VARIABLE_WEHN_AUTO
		m_pAscimp->iHeaderLines = nMainHeaderLines;
		m_pAscimp->iSubHeaderLines = nSubHeaderLines;
		m_pAscimp->iAutoSubHeaderLines = nAutoSubHeaderLines ? 1 : 0;;
	}
	return true;
}

///---END SUPPORT_AUTO_HEADER_LINES
